/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import jp.asamomiji.BasicProgram;
import jp.asamomiji.MachineLanguageProgram;
import jp.asamomiji.Program;

public class FSKPlayer {
    private boolean basicMode = true;
    private String fileName = null;
    private int startAddress = -1;
    private String programName = "PROGRAM";
    private int volume = 20;
    private AudioFormat format;
    private DataLine.Info info;
    private SourceDataLine line;
    private double f0;
    private double f1;
    private double fc;
    private double fs;
    private int samplesPerUnit;
    private int byteLengthPerSample;
    private byte[] sample0;
    private byte[] sample1;

    public FSKPlayer(double fc, double f0, double f1, double fs, int len) {
        this.fc = fc;
        this.f0 = f0;
        this.f1 = f1;
        this.fs = fs;
        this.byteLengthPerSample = len;
        this.samplesPerUnit = (int)(fs / fc);
        this.sample0 = new byte[this.samplesPerUnit * this.byteLengthPerSample];
        this.sample1 = new byte[this.samplesPerUnit * this.byteLengthPerSample];
    }

    private void setData(byte[] data, double frequency, double amplitude) {
        int n = (int)Math.floor((this.fs / (2.0 * frequency) + 1.0) / 2.0);
        int i = 0;
        while (i < this.samplesPerUnit) {
            double temp = 0.0;
            double t = (double)i / ((double)this.samplesPerUnit * this.fc);
            int k = 1;
            while (k <= n) {
                temp += Math.sin((double)((2 * k - 1) * 2) * Math.PI * frequency * t) / (double)(2 * k - 1);
                ++k;
            }
            int v = (int)(amplitude * 4.0 * temp / Math.PI);
            switch (this.byteLengthPerSample) {
                case 1: {
                    data[i] = (byte)(v & 0xFF);
                    break;
                }
                case 2: {
                    data[2 * i] = (byte)((v & 0xFF00) >> 8);
                    data[2 * i + 1] = (byte)(v & 0xFF);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            ++i;
        }
    }

    private void createSampleUnit(double amplitude) {
        this.setData(this.sample0, this.f0, amplitude);
        this.setData(this.sample1, this.f1, amplitude);
    }

    private void writeBit(int value) {
        if (value == 0) {
            this.line.write(this.sample0, 0, this.sample0.length);
        } else {
            this.line.write(this.sample1, 0, this.sample1.length);
        }
    }

    private void writeByte(int value) {
        value &= 0xFF;
        this.writeBit(0);
        int i = 0;
        while (i < 8) {
            this.writeBit(value % 2 == 0 ? 0 : 1);
            value >>= 1;
            ++i;
        }
        this.writeBit(1);
        this.writeBit(1);
    }

    private void writeByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            this.writeByte(array[i]);
            ++i;
        }
    }

    private void initializeAudio() {
        this.format = new AudioFormat((float)this.fs, this.byteLengthPerSample * 8, 1, true, true);
        this.info = new DataLine.Info(SourceDataLine.class, this.format);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(this.info);
            this.line.open(this.format);
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException("fail to initialize sound I/O");
        }
        this.line.start();
    }

    private void terminateAudio() {
        this.line.drain();
    }

    private byte[] createHeader(Program p) {
        byte[] header = new byte[33];
        int index = 0;
        String name = p.getName();
        byte[] codes = null;
        if (name.length() > 15) {
            name = name.substring(0, 16);
        }
        try {
            codes = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            codes = null;
        }
        if (codes != null) {
            int i = 0;
            while (i < codes.length) {
                header[index++] = codes[i];
                ++i;
            }
        }
        int i = name.length();
        while (i < 16) {
            header[index++] = 0;
            ++i;
        }
        int addr = p.getStartAddress();
        header[index++] = (byte)((addr & 0xFF00) >> 8);
        header[index++] = (byte)(addr & 0xFF);
        byte[] data = p.toByteArray();
        header[index++] = (byte)((data.length & 0xFF00) >> 8);
        header[index++] = (byte)(data.length & 0xFF);
        header[index++] = (byte)(p.getKind() & 0xFF);
        int i2 = 0;
        while (i2 < 11) {
            header[index++] = 0;
            ++i2;
        }
        int sum = 0;
        int i3 = 0;
        while (i3 < 32) {
            sum += header[i3];
            ++i3;
        }
        header[index++] = (byte)(sum & 0xFF);
        return header;
    }

    private void writeProgram(Program p) {
        byte[] header = this.createHeader(p);
        this.writeBit(1);
        int i = 0;
        while (i < 28) {
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(1);
            this.writeBit(0);
            ++i;
        }
        i = 0;
        while (i < 3828) {
            this.writeBit(1);
            ++i;
        }
        this.writeByteArray(header);
        i = 0;
        while (i < 255) {
            this.writeBit(1);
            ++i;
        }
        this.writeByteArray(p.toByteArray());
        this.writeByte(p.getSum() & 0xFF);
    }

    private void usage() {
        System.err.println("java -jar fskplayer.jar [-basic|-machine] -r <file> -a <addr> [-n <name>] [-v <volume>]");
    }

    private void processArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].equals("-basic")) {
                    this.basicMode = true;
                } else if (args[i].equals("-machine")) {
                    this.basicMode = false;
                } else if (args[i].equals("-r")) {
                    this.fileName = args[++i];
                } else if (args[i].equals("-a")) {
                    this.startAddress = Integer.decode(args[++i]);
                } else if (args[i].equals("-n")) {
                    this.programName = args[++i];
                } else if (args[i].equals("-v")) {
                    this.volume = Integer.decode(args[++i]);
                    if (this.volume < 0) {
                        this.volume = 0;
                    } else if (this.volume > 100) {
                        this.volume = 100;
                    }
                } else {
                    this.usage();
                    System.exit(1);
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Number Format Error: " + e.getMessage());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.usage();
                System.exit(1);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        FSKPlayer player = new FSKPlayer(600.0, 1200.0, 2400.0, 44100.0, 2);
        Program program = null;
        player.processArguments(args);
        if (player.fileName == null) {
            player.usage();
            System.exit(1);
        }
        if (!player.basicMode && player.startAddress < 0) {
            System.err.println("Start address must be specified for machine language mode.");
            player.usage();
            System.exit(1);
        }
        program = player.basicMode ? new BasicProgram(player.programName) : new MachineLanguageProgram(player.programName, player.startAddress);
        try {
            program.readProgram(player.fileName);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not Found: " + player.fileName);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("I/O error occured");
            System.exit(1);
        }
        player.createSampleUnit((Math.pow(2.0, player.byteLengthPerSample * 8 - 1) - 1.0) * (double)player.volume / 100.0);
        player.initializeAudio();
        player.writeProgram(program);
        player.terminateAudio();
    }
}

