/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.asamomiji.Program;

public class BasicProgram
extends Program {
    private Vector<Line> lines = new Vector();

    public BasicProgram(String name) {
        super(name);
    }

    @Override
    public int getStartAddress() {
        return 582;
    }

    @Override
    public int getKind() {
        return 0;
    }

    private Line parseLine(String s) {
        Line line = null;
        boolean normal = true;
        Pattern p = Pattern.compile("^(\\d+)\\s*(.*)$");
        Matcher m = p.matcher(s);
        if (m.find()) {
            StringBuffer sb = new StringBuffer(m.group(2).toUpperCase());
            int index = 0;
            while (index < sb.length()) {
                char c0 = sb.charAt(index);
                if (c0 == '\\' && index + 1 < sb.length()) {
                    char c1 = sb.charAt(index + 1);
                    if (c1 == '\\') {
                        sb.deleteCharAt(index + 1);
                    } else if (index + 2 < sb.length()) {
                        try {
                            sb.replace(index, index + 3, new String(new char[]{(char)Integer.parseInt(sb.substring(index + 1, index + 3), 16)}));
                        }
                        catch (NumberFormatException e) {
                            System.err.println(s);
                            System.err.println("invalid digits expression " + e.getMessage());
                            normal = false;
                        }
                    } else {
                        System.err.println(s);
                        System.err.println("\"\\\" must be followed by 2 hex digits.");
                        normal = false;
                    }
                }
                ++index;
            }
            if (normal) {
                line = new Line(Integer.parseInt(m.group(1)), sb.toString());
            }
        }
        return line;
    }

    private void convertToByteArray() {
        Iterator<Line> itr = this.lines.iterator();
        Byte[] template = new Byte[256];
        ArrayList<Byte> values = new ArrayList<Byte>();
        int i = 0;
        while (i < 255) {
            template[i] = (byte)i;
            ++i;
        }
        while (itr.hasNext()) {
            Line line = itr.next();
            int number = line.getNumber();
            values.add(template[(number & 0xFF) >> 8]);
            values.add(template[number & 0xFF]);
            String s = line.getBody();
            int pos = 0;
            while (pos < s.length()) {
                values.add(template[s.charAt(pos) & 0xFF]);
                ++pos;
            }
            values.add((byte)0);
        }
        values.add((byte)-33);
        values.add((byte)-33);
        byte[] a = new byte[values.size()];
        int i2 = 0;
        while (i2 < a.length) {
            a[i2] = (Byte)values.get(i2);
            ++i2;
        }
        this.setByteArray(a);
    }

    @Override
    public void readProgram(String fileName) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
            String s = reader.readLine();
            while (s != null) {
                Line line = this.parseLine(s);
                if (line != null) {
                    this.lines.addElement(line);
                }
                s = reader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.convertToByteArray();
        this.recalcSum();
    }

    class Line {
        private int number;
        private String body;

        public Line() {
        }

        public Line(int number, String body) {
            this.number = number;
            this.body = body;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public int getNumber() {
            return this.number;
        }

        public void setBody(String s) {
            this.body = s;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.number)) + " " + this.body;
        }
    }
}

