/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound.tone;

import jp.or.rim.kt.kemusiro.sound.tone.WaveGeneratable;

public class SquareWave
implements WaveGeneratable {
    private static double[] frequencyTable;

    private double normalize(double d, double d2) {
        return d2 - Math.floor(d2 * d) / d;
    }

    public double getValue(int n, double d) {
        double d2 = frequencyTable[n];
        if (this.normalize(d2, d) < 0.5 / d2) {
            return 1.0;
        }
        return -1.0;
    }

    public String toString() {
        return "Square Wave";
    }

    static {
        double d = 440.0;
        frequencyTable = new double[128];
        int n = 0;
        while (n < 128) {
            SquareWave.frequencyTable[n] = d * Math.pow(2.0, (double)(n - 69) / 12.0);
            ++n;
        }
    }
}

