/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import jp.or.rim.kt.kemusiro.sound.FMGeneralInstrument;
import jp.or.rim.kt.kemusiro.sound.LabelPrinter;
import jp.or.rim.kt.kemusiro.sound.MMLPlayer;
import jp.or.rim.kt.kemusiro.sound.tone.FMParameter;

public class MMLPlayerApplet
extends JApplet {
    private Container container;
    private JTextField ch1;
    private JTextField ch2;
    private JTextField ch3;
    private JRadioButton[] algorithmButton;
    private int currentAlgorithm;
    private JButton[] onOffStatus;
    private JTextField[] multiplier;
    private JTextField[] attackRate;
    private JTextField[] decayRate;
    private JTextField[] sustainRate;
    private JTextField[] releaseRate;
    private JTextField[] sustainLevel;
    private JTextField[] maxLevel;
    private JButton buttonPlay;
    private JButton buttonStop;
    private MMLPlayer player;
    private JLabel messageLabel;
    private LabelPrinter printer;

    public void init() {
        JPanel jPanel;
        JComponent jComponent;
        this.player = new MMLPlayer(new LineListener(){

            public void update(LineEvent lineEvent) {
                if (lineEvent.getType() == LineEvent.Type.STOP) {
                    MMLPlayerApplet.this.printer.send("please input MML strings!");
                }
            }
        });
        this.container = this.getContentPane();
        Box box = Box.createVerticalBox();
        this.container.add(box);
        JLabel jLabel = new JLabel("MML Player");
        jLabel.setFont(new Font("SansSerif", 1, 20));
        box.add(jLabel);
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Channel1", 2));
        this.ch1 = new JTextField();
        this.ch1.setMaximumSize(new Dimension(480, 20));
        box2.add(this.ch1);
        Box box3 = Box.createHorizontalBox();
        box3.add(new JLabel("Channel2", 2));
        this.ch2 = new JTextField();
        this.ch2.setMaximumSize(new Dimension(480, 20));
        box3.add(this.ch2);
        Box box4 = Box.createHorizontalBox();
        box4.add(new JLabel("Channel3", 2));
        this.ch3 = new JTextField();
        this.ch3.setMaximumSize(new Dimension(480, 20));
        box4.add(this.ch3);
        Box box5 = Box.createHorizontalBox();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.algorithmButton = new JRadioButton[8];
        box5.add(new JLabel("Algorithm:"));
        box5.add(Box.createHorizontalGlue());
        this.currentAlgorithm = 4;
        int n = 0;
        while (n < 8) {
            this.algorithmButton[n] = new JRadioButton(Integer.toString(n), n == this.currentAlgorithm);
            this.algorithmButton[n].addActionListener(new RadioButtonListener());
            buttonGroup.add(this.algorithmButton[n]);
            box5.add(this.algorithmButton[n]);
            box5.add(Box.createHorizontalGlue());
            ++n;
        }
        Box box6 = Box.createHorizontalBox();
        this.onOffStatus = new JButton[4];
        this.multiplier = new JTextField[4];
        this.attackRate = new JTextField[4];
        this.decayRate = new JTextField[4];
        this.sustainRate = new JTextField[4];
        this.releaseRate = new JTextField[4];
        this.sustainLevel = new JTextField[4];
        this.maxLevel = new JTextField[4];
        int n2 = 0;
        while (n2 < 4) {
            jComponent = Box.createVerticalBox();
            box6.add(jComponent);
            jPanel = new JPanel(new GridLayout(8, 2, 2, 2));
            jComponent.add(jPanel);
            jPanel.setBorder(new EtchedBorder());
            JLabel jLabel2 = new JLabel("OP" + n2);
            jPanel.add(jLabel2);
            this.onOffStatus[n2] = new JButton("ON");
            jPanel.add(this.onOffStatus[n2]);
            this.onOffStatus[n2].addActionListener(new ButtonListener());
            JLabel jLabel3 = new JLabel("multiplier");
            jPanel.add(jLabel3);
            this.multiplier[n2] = new JTextField("1.0");
            jPanel.add(this.multiplier[n2]);
            JLabel jLabel4 = new JLabel("AR");
            jPanel.add(jLabel4);
            this.attackRate[n2] = new JTextField("20.0");
            jPanel.add(this.attackRate[n2]);
            JLabel jLabel5 = new JLabel("DR");
            jPanel.add(jLabel5);
            this.decayRate[n2] = new JTextField("7.0");
            jPanel.add(this.decayRate[n2]);
            JLabel jLabel6 = new JLabel("SR");
            jPanel.add(jLabel6);
            this.sustainRate[n2] = new JTextField("0.8");
            jPanel.add(this.sustainRate[n2]);
            JLabel jLabel7 = new JLabel("RR");
            jPanel.add(jLabel7);
            this.releaseRate[n2] = new JTextField("4.0");
            jPanel.add(this.releaseRate[n2]);
            JLabel jLabel8 = new JLabel("SL");
            jPanel.add(jLabel8);
            this.sustainLevel[n2] = new JTextField("0.8");
            jPanel.add(this.sustainLevel[n2]);
            JLabel jLabel9 = new JLabel("MAX");
            jPanel.add(jLabel9);
            this.maxLevel[n2] = new JTextField("1.0");
            jPanel.add(this.maxLevel[n2]);
            ++n2;
        }
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout(0));
        this.buttonPlay = new JButton("Play");
        jComponent.add(this.buttonPlay);
        this.buttonStop = new JButton("Stop");
        jComponent.add(this.buttonStop);
        this.buttonPlay.addActionListener(new ButtonListener());
        this.buttonStop.addActionListener(new ButtonListener());
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.messageLabel = new JLabel("please input MML strings!");
        this.printer = new LabelPrinter(this.messageLabel);
        this.player.setPrinter(this.printer);
        jPanel.add(this.messageLabel);
        box.add(box2);
        box.add(box3);
        box.add(box4);
        box.add(box5);
        box.add(box6);
        box.add(jComponent);
        box.add(jPanel);
    }

    private FMParameter getFMParameter(int n) {
        FMParameter fMParameter = new FMParameter(n, 4);
        fMParameter.setAlgorithm(this.currentAlgorithm);
        int n2 = 0;
        while (n2 < 4) {
            fMParameter.setMultiplier(n2, Double.parseDouble(this.multiplier[n2].getText()));
            fMParameter.setAttackRate(n2, Double.parseDouble(this.attackRate[n2].getText()));
            fMParameter.setDecayRate(n2, Double.parseDouble(this.decayRate[n2].getText()));
            fMParameter.setSustainRate(n2, Double.parseDouble(this.sustainRate[n2].getText()));
            fMParameter.setReleaseRate(n2, Double.parseDouble(this.releaseRate[n2].getText()));
            fMParameter.setSustainLevel(n2, Double.parseDouble(this.sustainLevel[n2].getText()));
            fMParameter.setMaxLevel(n2, Double.parseDouble(this.maxLevel[n2].getText()));
            ++n2;
        }
        return fMParameter;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == MMLPlayerApplet.this.buttonPlay) {
                String[] stringArray = new String[]{MMLPlayerApplet.this.ch1.getText(), MMLPlayerApplet.this.ch2.getText(), MMLPlayerApplet.this.ch3.getText()};
                FMGeneralInstrument.setParameter(0, MMLPlayerApplet.this.getFMParameter(0));
                MMLPlayerApplet.this.player.setMML(stringArray);
                MMLPlayerApplet.this.printer.send("start");
                MMLPlayerApplet.this.player.start();
            } else if (jButton == MMLPlayerApplet.this.buttonStop) {
                MMLPlayerApplet.this.player.stop();
                MMLPlayerApplet.this.printer.send("stopping...");
            } else {
                int n = 0;
                while (n < 4) {
                    if (jButton == MMLPlayerApplet.this.onOffStatus[n]) {
                        if (MMLPlayerApplet.this.onOffStatus[n].getText().equals("ON")) {
                            MMLPlayerApplet.this.onOffStatus[n].setText("OFF");
                        } else {
                            MMLPlayerApplet.this.onOffStatus[n].setText("ON");
                        }
                    }
                    ++n;
                }
            }
        }
    }

    class RadioButtonListener
    implements ActionListener {
        RadioButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            int n = 0;
            while (n < 7) {
                if (jRadioButton == MMLPlayerApplet.this.algorithmButton[n]) {
                    MMLPlayerApplet.this.currentAlgorithm = n;
                    return;
                }
                ++n;
            }
        }
    }

    class FMButtonListener
    implements ActionListener {
        FMButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
        }
    }
}

