/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import java.io.IOException;
import javax.sound.sampled.LineListener;
import jp.or.rim.kt.kemusiro.sound.ConsolePrinter;
import jp.or.rim.kt.kemusiro.sound.FMGeneralInstrument;
import jp.or.rim.kt.kemusiro.sound.MMLCompiler;
import jp.or.rim.kt.kemusiro.sound.MMLException;
import jp.or.rim.kt.kemusiro.sound.MessagePrinter;
import jp.or.rim.kt.kemusiro.sound.MusicScore;
import jp.or.rim.kt.kemusiro.sound.StreamingSoundPlayer;
import jp.or.rim.kt.kemusiro.sound.WaveInputStream;

public class MMLPlayer
implements Runnable {
    private MessagePrinter printer;
    private LineListener listener;
    private Thread thread;
    private String[] mmls;

    public MMLPlayer() {
        this.listener = null;
    }

    public MMLPlayer(LineListener lineListener) {
        this.listener = lineListener;
    }

    private static void usage() {
        System.out.println("java MMLPlayer MML1 [MML2 [MML3]]");
        System.exit(1);
    }

    public void setPrinter(MessagePrinter messagePrinter) {
        this.printer = messagePrinter;
    }

    public MessagePrinter getPrinter() {
        return this.printer;
    }

    public void play(String[] stringArray) throws MMLException {
        int n = 240;
        int n2 = 22100;
        int n3 = 8;
        MusicScore musicScore = new MusicScore(n, stringArray.length);
        MMLCompiler mMLCompiler = new MMLCompiler(n, stringArray.length);
        WaveInputStream waveInputStream = new WaveInputStream(musicScore, n2, n3);
        mMLCompiler.compile(musicScore, stringArray);
        StreamingSoundPlayer streamingSoundPlayer = new StreamingSoundPlayer(n2, n3, this.listener);
        byte[] byArray = new byte[n2 * streamingSoundPlayer.getFrameSize() / 2];
        streamingSoundPlayer.start();
        try {
            int n4 = 0;
            while (this.thread != null && n4 >= 0) {
                n4 = waveInputStream.read(byArray, 0, byArray.length);
                if (n4 < 0) continue;
                streamingSoundPlayer.write(byArray, 0, n4);
            }
            streamingSoundPlayer.drain();
            streamingSoundPlayer.stop();
            streamingSoundPlayer.close();
            streamingSoundPlayer = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setName("MMLPlayer");
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    public void run() {
        try {
            this.play(this.mmls);
        }
        catch (MMLException mMLException) {
            this.getPrinter().send(mMLException.getMessage());
        }
        this.thread = null;
    }

    public void setMML(String[] stringArray) {
        this.mmls = stringArray;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length == 0) {
            MMLPlayer.usage();
        }
        if (stringArray[0].equals("-f")) {
            FMGeneralInstrument.readParameter(stringArray[1]);
            stringArray2 = new String[stringArray.length - 2];
            int n = 2;
            while (n < stringArray.length) {
                stringArray2[n - 2] = stringArray[n];
                ++n;
            }
            stringArray = stringArray2;
        } else {
            FMGeneralInstrument.readParameter("fmparameters.txt");
        }
        stringArray2 = new MMLPlayer();
        stringArray2.setPrinter(new ConsolePrinter());
        stringArray2.setMML(stringArray);
        stringArray2.start();
        try {
            while (stringArray2.thread != null) {
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        System.exit(0);
    }
}

