/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import jp.or.rim.kt.kemusiro.sound.tone.Envelope;
import jp.or.rim.kt.kemusiro.sound.tone.WaveGeneratable;

public abstract class Instrument {
    protected WaveGeneratable wave;
    protected Envelope envelope;
    private double currentTime;
    private double timeStep;

    public void setTimeStep(double d) {
        this.timeStep = d;
        this.envelope.setTimeStep(d);
    }

    public double getValue(int n) {
        double d = this.envelope.getValue() * this.wave.getValue(n, this.currentTime);
        this.currentTime += this.timeStep;
        return d;
    }

    public void press() {
        this.currentTime = 0.0;
        this.envelope.press();
    }

    public void release() {
        this.envelope.release();
    }

    public abstract String getName();
}

