/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound.tone;

import jp.or.rim.kt.kemusiro.sound.tone.Envelope;
import jp.or.rim.kt.kemusiro.sound.tone.WaveGeneratable;

public class FMOperator
implements WaveGeneratable {
    private WaveGeneratable pitch = null;
    private WaveGeneratable modulation = null;
    private Envelope envelope = null;
    private double multiplier = 1.0;
    private boolean mask = true;

    public void setInput(WaveGeneratable waveGeneratable, WaveGeneratable waveGeneratable2) {
        this.pitch = waveGeneratable;
        this.modulation = waveGeneratable2;
    }

    public void setMultiplier(double d) {
        this.multiplier = d;
    }

    public void setMask(boolean bl) {
        this.mask = bl;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public void setTimeStep(double d) {
        this.envelope.setTimeStep(d);
    }

    public void press() {
        this.envelope.press();
    }

    public void release() {
        this.envelope.release();
    }

    public double getValue(int n, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.mask) {
            d2 = Math.PI * 2 * (this.pitch.getValue(n, d) + 1.0);
            if (this.modulation != null) {
                d3 = Math.PI * 2 * (this.modulation.getValue(n, d) + 1.0);
            }
            d4 = Math.sin(this.multiplier * (d2 + d3));
            if (this.envelope != null) {
                d4 *= this.envelope.getValue();
            }
        }
        return d4;
    }
}

