/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import jp.or.rim.kt.kemusiro.sound.ChangeInstrument;
import jp.or.rim.kt.kemusiro.sound.ChangeTempo;
import jp.or.rim.kt.kemusiro.sound.Instrument;
import jp.or.rim.kt.kemusiro.sound.MusicEvent;
import jp.or.rim.kt.kemusiro.sound.MusicScore;
import jp.or.rim.kt.kemusiro.sound.NoteOff;
import jp.or.rim.kt.kemusiro.sound.NoteOn;

public class WaveInputStream
extends InputStream {
    private MusicScore score;
    private int samplingRate;
    private int samplingDepth;
    private Instrument[] insts;
    private NoteOn[] notes;
    private int currentTick = 0;
    private double currentTime = 0.0;
    private double[] time;
    private int currentTempo = 60;
    private int pos = 0;
    private LinkedList events;
    private ByteArrayOutputStream output;
    private byte[] buffer;

    public WaveInputStream(MusicScore musicScore, int n, int n2) {
        this.score = musicScore;
        this.samplingRate = n;
        if (n2 % 8 != 0 || n2 == 0 || n2 > 32) {
            throw new RuntimeException("unsupported bit depth: " + n2);
        }
        this.samplingDepth = n2;
        this.events = musicScore.getEventList();
        this.insts = new Instrument[musicScore.getChannelCount()];
        this.notes = new NoteOn[musicScore.getChannelCount()];
        this.time = new double[musicScore.getChannelCount()];
        this.output = new ByteArrayOutputStream(4 * this.samplingRate / musicScore.getTickPerBeat());
    }

    private double getTimePerBeat() {
        return 60.0 / (double)this.currentTempo;
    }

    private double getTimePerTick() {
        return this.getTimePerBeat() / (double)this.score.getTickPerBeat();
    }

    private int getSampleCountPerTick() {
        return (int)(this.getTimePerTick() * (double)this.samplingRate);
    }

    private void processEvent() {
        MusicEvent musicEvent = (MusicEvent)this.events.getFirst();
        while (musicEvent != null && musicEvent.getTick() == this.currentTick) {
            int n = musicEvent.getChannel();
            if (musicEvent instanceof ChangeInstrument) {
                this.insts[n] = ((ChangeInstrument)musicEvent).getInstrument();
                this.insts[n].setTimeStep(1.0 / (double)this.samplingRate);
            } else if (musicEvent instanceof ChangeTempo) {
                this.currentTempo = ((ChangeTempo)musicEvent).getTempo();
            } else if (musicEvent instanceof NoteOn) {
                this.notes[n] = (NoteOn)musicEvent;
                this.insts[n].press();
            } else if (musicEvent instanceof NoteOff) {
                this.insts[n].release();
            }
            this.events.remove(0);
            if (this.events.size() == 0) break;
            musicEvent = (MusicEvent)this.events.getFirst();
        }
    }

    private void writeDouble(double d) {
        int n = (int)d;
        if (this.samplingDepth == 32) {
            this.output.write((n & 0xFF000000) >> 24);
        }
        if (this.samplingDepth >= 24) {
            this.output.write((n & 0xFF0000) >> 16);
        }
        if (this.samplingDepth >= 16) {
            this.output.write((n & 0xFF00) >> 8);
        }
        this.output.write(n & 0xFF);
    }

    private void processNote() {
        int n = 0;
        while (n < this.getSampleCountPerTick()) {
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.score.getChannelCount()) {
                if (this.notes[n2] != null) {
                    d += (double)this.notes[n2].getVelocity() * this.insts[n2].getValue(this.notes[n2].getNumber());
                }
                ++n2;
            }
            this.writeDouble(d / (double)this.score.getChannelCount());
            ++n;
        }
    }

    private int fillBuffer() {
        this.output.reset();
        int n = 0;
        while (n < this.score.getTickPerBeat()) {
            if (this.events.size() == 0) break;
            if (((MusicEvent)this.events.get(0)).getTick() == this.currentTick) {
                this.processEvent();
            }
            this.processNote();
            ++this.currentTick;
            ++n;
        }
        this.buffer = this.output.toByteArray();
        return this.buffer.length;
    }

    public int read() throws IOException {
        if (this.buffer == null || this.pos == this.buffer.length) {
            if (this.fillBuffer() <= 0) {
                this.buffer = null;
                return -1;
            }
            this.pos = 0;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public void close() throws IOException {
        this.output.close();
    }
}

