/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import jp.or.rim.kt.kemusiro.sound.ChangeInstrument;
import jp.or.rim.kt.kemusiro.sound.ChangeTempo;
import jp.or.rim.kt.kemusiro.sound.MusicEvent;
import jp.or.rim.kt.kemusiro.sound.SquareWaveInstrument;

public final class MusicScore {
    private int tickPerBeat;
    private int channelCount;
    private LinkedList eventList;
    private int defaultTempo = 100;

    public MusicScore(int n, int n2) {
        this.tickPerBeat = n;
        this.channelCount = n2;
        this.eventList = new LinkedList();
        int n3 = 0;
        while (n3 < n2) {
            this.add(new ChangeInstrument(0, n3, new SquareWaveInstrument()));
            this.add(new ChangeTempo(0, n3, this.defaultTempo));
            ++n3;
        }
    }

    public int getTickPerBeat() {
        return this.tickPerBeat;
    }

    public LinkedList getEventList() {
        return this.eventList;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void add(MusicEvent musicEvent) {
        int n = this.eventList.size() - 1;
        while (n >= 0) {
            MusicEvent musicEvent2 = (MusicEvent)this.eventList.get(n);
            if (musicEvent2.getTick() <= musicEvent.getTick()) {
                this.eventList.add(n + 1, musicEvent);
                return;
            }
            --n;
        }
        this.eventList.add(0, musicEvent);
    }

    public void dump(OutputStream outputStream) {
        Iterator iterator = this.eventList.iterator();
        while (iterator.hasNext()) {
            MusicEvent musicEvent = (MusicEvent)iterator.next();
            System.out.print("tick:" + musicEvent.getTick());
            System.out.print(" ch:" + musicEvent.getChannel());
            System.out.println(musicEvent.toString());
        }
    }

    public String toString() {
        return "MusicScore: Ticks/Beat=" + this.tickPerBeat + " channelCount:" + this.channelCount;
    }
}

