/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import jp.or.rim.kt.kemusiro.sound.ChangeInstrument;
import jp.or.rim.kt.kemusiro.sound.ChangeTempo;
import jp.or.rim.kt.kemusiro.sound.FMGeneralInstrument;
import jp.or.rim.kt.kemusiro.sound.Instrument;
import jp.or.rim.kt.kemusiro.sound.MMLException;
import jp.or.rim.kt.kemusiro.sound.MusicScore;
import jp.or.rim.kt.kemusiro.sound.NoteOff;
import jp.or.rim.kt.kemusiro.sound.NoteOn;
import jp.or.rim.kt.kemusiro.sound.SineWaveInstrument;
import jp.or.rim.kt.kemusiro.sound.SquareWaveInstrument;

public class MMLCompiler {
    private MusicScore score;
    private int tickPerBeat = 240;
    private int maxAmplitude = 127;
    private int currentTempo = 60;
    private int initialOctave = 4;
    private int[] currentOctave;
    private int currentVolume = 8;
    private int currentTick = this.tickPerBeat;
    private int initialQuantity = 8;
    private int[] currentQuantity;
    private int tick = 0;
    private String mml;
    private int position;

    public MMLCompiler() {
    }

    public MMLCompiler(int n, int n2) {
        this.tickPerBeat = n;
        this.currentOctave = new int[n2];
        this.currentQuantity = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.currentOctave[n3] = this.initialOctave;
            this.currentQuantity[n3] = this.initialQuantity;
            ++n3;
        }
    }

    private int getNumber(StringBuffer stringBuffer) {
        int n = 0;
        while (stringBuffer.length() > 0 && Character.isDigit(stringBuffer.charAt(0))) {
            n *= 10;
            n += Character.digit(stringBuffer.charAt(0), 10);
            stringBuffer.deleteCharAt(0);
        }
        return n;
    }

    private int getNoteNumber(int n, char c) throws MMLException {
        int n2 = n * 12 + 12;
        switch (c) {
            case 'c': {
                n2 += 0;
                break;
            }
            case 'd': {
                n2 += 2;
                break;
            }
            case 'e': {
                n2 += 4;
                break;
            }
            case 'f': {
                n2 += 5;
                break;
            }
            case 'g': {
                n2 += 7;
                break;
            }
            case 'a': {
                n2 += 9;
                break;
            }
            case 'b': {
                n2 += 11;
                break;
            }
            default: {
                throw new MMLException();
            }
        }
        return n2;
    }

    private int getTick(StringBuffer stringBuffer) {
        int n;
        block4: {
            char c;
            block5: {
                n = this.currentTick;
                if (stringBuffer.length() == 0) break block4;
                c = stringBuffer.charAt(0);
                if (!Character.isDigit(c)) break block5;
                n = this.tickPerBeat * 4 / this.getNumber(stringBuffer);
                if (stringBuffer.length() == 0) break block4;
                c = stringBuffer.charAt(0);
            }
            if (c == '.') {
                n = n * 3 / 2;
                stringBuffer.deleteCharAt(0);
            }
        }
        return n;
    }

    private void processNote(StringBuffer stringBuffer, int n, char c) throws MMLException {
        int n2;
        int n3 = this.getNoteNumber(this.currentOctave[n], c);
        if (stringBuffer.length() > 0 && ((n2 = stringBuffer.charAt(0)) == 43 || n2 == 45)) {
            n3 = n2 == 43 ? ++n3 : --n3;
            stringBuffer.deleteCharAt(0);
        }
        if (n3 < 0 || n3 > 127) {
            throw new MMLException("invalid note number: " + n3);
        }
        this.score.add(new NoteOn(this.tick, n, n3, this.currentVolume * 8));
        n2 = this.getTick(stringBuffer);
        this.score.add(new NoteOff(this.tick + n2 * this.currentQuantity[n] / 8 - 1, n, n3, this.currentVolume * 8));
        this.tick += n2;
    }

    private void processChangeInstrument(StringBuffer stringBuffer, int n) throws MMLException {
        Instrument instrument;
        char c = stringBuffer.charAt(0);
        stringBuffer.deleteCharAt(0);
        switch (c) {
            case 'a': {
                instrument = new SquareWaveInstrument();
                break;
            }
            case 'b': {
                instrument = new SineWaveInstrument();
                break;
            }
            case 'c': {
                instrument = new FMGeneralInstrument(this.getNumber(stringBuffer));
                break;
            }
            default: {
                throw new MMLException("invalid program name");
            }
        }
        this.score.add(new ChangeInstrument(this.tick, n, instrument));
    }

    public void compile(MusicScore musicScore, String[] stringArray) throws MMLException {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && stringArray[n].length() > 0) {
                this.compile(musicScore, n, stringArray[n]);
            }
            ++n;
        }
    }

    public void compile(MusicScore musicScore, int n, String string) throws MMLException {
        StringBuffer stringBuffer = new StringBuffer(string);
        this.score = musicScore;
        this.tick = 0;
        block12: while (stringBuffer.length() > 0) {
            char c = stringBuffer.charAt(0);
            stringBuffer.deleteCharAt(0);
            c = Character.toLowerCase(c);
            switch (c) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.processNote(stringBuffer, n, c);
                    break;
                }
                case 'r': {
                    this.tick += this.getTick(stringBuffer);
                    break;
                }
                case 't': {
                    this.score.add(new ChangeTempo(this.tick, n, this.getNumber(stringBuffer)));
                    break;
                }
                case 'v': {
                    this.currentVolume = this.getNumber(stringBuffer);
                    if (this.currentVolume <= 7) continue block12;
                    throw new MMLException("voume must be in range of 0 to 7");
                }
                case 'l': {
                    this.currentTick = this.getTick(stringBuffer);
                    break;
                }
                case 'o': {
                    this.currentOctave[n] = this.getNumber(stringBuffer);
                    if (this.currentOctave[n] <= 7) continue block12;
                    throw new MMLException("octave must be in range of 0 to 7");
                }
                case 'q': {
                    this.currentQuantity[n] = this.getNumber(stringBuffer);
                    if (this.currentQuantity[n] != 0 && this.currentQuantity[n] <= 8) continue block12;
                    throw new MMLException("octave must be in range of 1 to 8");
                }
                case '>': {
                    System.out.println(">");
                    if (this.currentOctave[n] == 0) {
                        throw new MMLException("octave must be >= 0");
                    }
                    int n2 = n;
                    this.currentOctave[n2] = this.currentOctave[n2] - 1;
                    break;
                }
                case '<': {
                    if (this.currentOctave[n] == 7) {
                        throw new MMLException("octave must be <= 7");
                    }
                    int n3 = n;
                    this.currentOctave[n3] = this.currentOctave[n3] + 1;
                    break;
                }
                case '@': {
                    this.processChangeInstrument(stringBuffer, n);
                    break;
                }
                default: {
                    throw new MMLException("invalid MML command: " + c);
                }
            }
        }
    }
}

