/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jp.or.rim.kt.kemusiro.sound.Instrument;
import jp.or.rim.kt.kemusiro.sound.tone.DummyEnvelope;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm0;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm1;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm2;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm3;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm4;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm5;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm6;
import jp.or.rim.kt.kemusiro.sound.tone.FMAlgorithm7;
import jp.or.rim.kt.kemusiro.sound.tone.FMParameter;

public class FMGeneralInstrument
extends Instrument {
    private static Vector parameters = new Vector();

    public FMGeneralInstrument(int n) {
        FMParameter fMParameter = FMGeneralInstrument.findParameter(n);
        if (fMParameter == null) {
            throw new RuntimeException("can't find tone number: " + n);
        }
        switch (fMParameter.getAlgorithm()) {
            case 0: {
                this.wave = new FMAlgorithm0(fMParameter);
                break;
            }
            case 1: {
                this.wave = new FMAlgorithm1(fMParameter);
                break;
            }
            case 2: {
                this.wave = new FMAlgorithm2(fMParameter);
                break;
            }
            case 3: {
                this.wave = new FMAlgorithm3(fMParameter);
                break;
            }
            case 4: {
                this.wave = new FMAlgorithm4(fMParameter);
                break;
            }
            case 5: {
                this.wave = new FMAlgorithm5(fMParameter);
                break;
            }
            case 6: {
                this.wave = new FMAlgorithm6(fMParameter);
                break;
            }
            case 7: {
                this.wave = new FMAlgorithm7(fMParameter);
                break;
            }
            default: {
                throw new RuntimeException("invalid algorithm number");
            }
        }
        this.envelope = new DummyEnvelope();
    }

    private static FMParameter findParameter(int n) {
        int n2 = 0;
        while (n2 < parameters.size()) {
            FMParameter fMParameter = (FMParameter)parameters.elementAt(n2);
            if (fMParameter.getToneNumber() == n) {
                return fMParameter;
            }
            ++n2;
        }
        return null;
    }

    public static void readParameter(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                int n = Integer.parseInt(string2);
                int n2 = 4;
                FMParameter fMParameter = new FMParameter(n, n2);
                fMParameter.setAlgorithm(Integer.parseInt(bufferedReader.readLine()));
                int n3 = 0;
                while (n3 < n2) {
                    fMParameter.setMultiplier(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setAttackRate(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setDecayRate(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setSustainRate(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setReleaseRate(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setSustainLevel(n3, Double.parseDouble(bufferedReader.readLine()));
                    fMParameter.setMaxLevel(n3, Double.parseDouble(bufferedReader.readLine()));
                    ++n3;
                }
                parameters.add(fMParameter);
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.exit(1);
        }
    }

    public static void setParameter(int n, FMParameter fMParameter) {
        FMParameter fMParameter2 = FMGeneralInstrument.findParameter(n);
        if (fMParameter2 != null) {
            parameters.remove(fMParameter2);
            parameters.add(fMParameter);
        } else {
            parameters.add(fMParameter);
        }
    }

    public void setTimeStep(double d) {
        super.setTimeStep(d);
        ((FMAlgorithm)this.wave).setTimeStep(d);
    }

    public void press() {
        super.press();
        ((FMAlgorithm)this.wave).press();
    }

    public void release() {
        super.release();
        ((FMAlgorithm)this.wave).release();
    }

    public String getName() {
        return this.toString();
    }

    public String toString() {
        return "FM General";
    }
}

