/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound.tone;

import jp.or.rim.kt.kemusiro.sound.tone.Envelope;

public class ADSREnvelope
extends Envelope {
    private double attackRate;
    private double decayRate;
    private double sustainRate;
    private double releaseRate;
    private double sustainLevel;
    private double maxLevel;
    private double level;

    public ADSREnvelope(double d, double d2, double d3, double d4, double d5, double d6) {
        this.attackRate = d;
        this.decayRate = d2;
        this.sustainRate = d3;
        this.releaseRate = d4;
        this.sustainLevel = d5;
        this.maxLevel = d6;
    }

    public double getValueInPressing() {
        double d = this.maxLevel / this.attackRate;
        if (this.time < d) {
            this.level = this.attackRate * this.time;
            return this.level;
        }
        double d2 = d + this.sustainLevel / this.decayRate;
        if (this.time < d + d2) {
            this.level = this.maxLevel - this.decayRate * (this.time - d);
            return this.level;
        }
        this.level = Math.max(this.maxLevel - this.sustainLevel - this.sustainRate * (this.time - d2), 0.0);
        return this.level;
    }

    public double getValueInReleasing() {
        return Math.max(this.level - this.time * this.releaseRate, 0.0);
    }
}

