/*
 * Decompiled with CFR 0.152.
 */
package jp.or.rim.kt.kemusiro.sound.tone;

import jp.or.rim.kt.kemusiro.sound.tone.ADSREnvelope;
import jp.or.rim.kt.kemusiro.sound.tone.Envelope;
import jp.or.rim.kt.kemusiro.sound.tone.FMOperator;
import jp.or.rim.kt.kemusiro.sound.tone.FMParameter;
import jp.or.rim.kt.kemusiro.sound.tone.WaveGeneratable;

public abstract class FMAlgorithm
implements WaveGeneratable {
    private FMOperator[] operators;

    public FMAlgorithm(int n) {
        this.operators = new FMOperator[n];
        int n2 = 0;
        while (n2 < n) {
            this.operators[n2] = new FMOperator();
            ++n2;
        }
    }

    public FMOperator getOperator(int n) {
        return this.operators[n];
    }

    public void setInput(int n, WaveGeneratable waveGeneratable, WaveGeneratable waveGeneratable2) {
        this.operators[n].setInput(waveGeneratable, waveGeneratable2);
    }

    public void setMultiplier(int n, double d) {
        this.operators[n].setMultiplier(d);
    }

    public void setMask(int n, boolean bl) {
        this.operators[n].setMask(bl);
    }

    public void setEnvelope(int n, Envelope envelope) {
        this.operators[n].setEnvelope(envelope);
    }

    public void setTimeStep(double d) {
        int n = 0;
        while (n < this.operators.length) {
            this.operators[n].setTimeStep(d);
            ++n;
        }
    }

    public void press() {
        int n = 0;
        while (n < this.operators.length) {
            this.operators[n].press();
            ++n;
        }
    }

    public void release() {
        int n = 0;
        while (n < this.operators.length) {
            this.operators[n].release();
            ++n;
        }
    }

    public abstract double getValue(int var1, double var2);

    protected void setParameter(FMParameter fMParameter) {
        int n = 0;
        while (n < 4) {
            this.setMultiplier(n, fMParameter.getMultiplier(n));
            this.setEnvelope(n, new ADSREnvelope(fMParameter.getAttackRate(n), fMParameter.getDecayRate(n), fMParameter.getSustainRate(n), fMParameter.getReleaseRate(n), fMParameter.getSustainLevel(n), fMParameter.getMaxLevel(n)));
            ++n;
        }
    }
}

