/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Device;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.StateSet;

public abstract class AbstractDisplay
extends JComponent
implements Device,
StateSavable {
    public static final int DISPLAYTYPE_MONOCHROME = 0;
    public static final int DISPLAYTYPE_GREEN = 1;
    public static final int DISPLAYTYPE_AMBER = 2;
    public static final int DISPLAYTYPE_COLOR = 3;
    public static final int COLORMAP_DEFAULT = 0;
    public static final int COLORMAP_FILE = 1;
    public static final String PROPERTY_DISPLAY_COLOR = "display.color";
    public static final String PROPERTY_DISPLAY_COLORMAP = "display.colormap";
    public static final String PROPERTY_DISPLAY_TYPE = "display.type";
    public static final String PROPERTY_DISPLAY_SCALING = "display.scaling";
    protected Computer computer;
    protected int cx;
    protected int cy;
    protected int px;
    protected int py;
    protected int width;
    protected int height;
    protected int scaling = 1;
    private Refresher refresher = new Refresher();

    public AbstractDisplay(Computer computer, int cx, int cy, int px, int py) {
        this.computer = computer;
        this.cx = cx;
        this.cy = cy;
        this.px = px;
        this.py = py;
        this.width = cx * px;
        this.height = cy * py;
    }

    public void setPropertyOfDisplayType(int type) {
        String s;
        switch (type) {
            case 0: {
                s = "monochrome";
                break;
            }
            case 1: {
                s = "green";
                break;
            }
            case 2: {
                s = "amber";
                break;
            }
            case 3: {
                s = "color";
                break;
            }
            default: {
                s = "monochrome";
            }
        }
        Application.getProperties().setProperty(PROPERTY_DISPLAY_TYPE, s);
        this.initializeColors();
        this.initializeFonts();
    }

    public int getPropertyOfDisplayType() {
        Properties p = Application.getProperties();
        String m = p.getProperty(PROPERTY_DISPLAY_TYPE);
        String m_compat = p.getProperty(PROPERTY_DISPLAY_COLOR);
        if (m_compat != null) {
            p.setProperty(PROPERTY_DISPLAY_TYPE, m_compat);
            p.remove(PROPERTY_DISPLAY_COLOR);
            m = m_compat;
        }
        if (m == null) {
            return 0;
        }
        if (m.equals("monochrome")) {
            return 0;
        }
        if (m.equals("green")) {
            return 1;
        }
        if (m.equals("amber") || m.equals("orange")) {
            return 2;
        }
        if (m.equals("color")) {
            return 3;
        }
        return 0;
    }

    public void setDisplayColorMap(int kind, String file) {
        if (kind == 0) {
            Application.getProperties().setProperty(PROPERTY_DISPLAY_COLORMAP, "default");
        } else if (kind == 1) {
            if (file == null || file.length() == 0) {
                throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u304b\u30d5\u30a1\u30a4\u30eb\u540d\u9577\u304c\u30bc\u30ed\u3067\u3059\u3002");
            }
            this.readColorMapFile(file);
            Application.getProperties().setProperty(PROPERTY_DISPLAY_COLORMAP, "file " + file);
        }
        this.applyDisplayColor();
        this.initializeFonts();
    }

    public int getPropertyOfDisplayColorMap() {
        String m = Application.getProperties().getProperty(PROPERTY_DISPLAY_COLORMAP, "default");
        if (m.matches("^default\\s.*$")) {
            return 0;
        }
        if (m.matches("^file\\s.*$")) {
            return 1;
        }
        return 0;
    }

    public String getPropertyOfDisplayColorMapFile() {
        String m = Application.getProperties().getProperty(PROPERTY_DISPLAY_COLORMAP);
        if (m == null) {
            return null;
        }
        if (m.matches("^default\\s.*$")) {
            return null;
        }
        if (m.matches("^file\\s.*$")) {
            return m.replaceFirst("^file\\s*", "");
        }
        return null;
    }

    public int getPropertyOfDisplayScaling() {
        int value;
        String m = Application.getProperties().getProperty(PROPERTY_DISPLAY_SCALING, "1");
        try {
            value = Integer.parseInt(m);
        }
        catch (NumberFormatException e) {
            value = 1;
        }
        return value;
    }

    public void setPropertyOfDisplayScaling(int scaling) {
        this.scaling = scaling;
        this.computer.getApplication().pack();
        Application.getProperties().setProperty(PROPERTY_DISPLAY_SCALING, Integer.toString(scaling));
    }

    protected abstract boolean readColorMapFile(String var1);

    protected abstract void applyDisplayColor();

    protected abstract void initializeColors();

    protected abstract void initializeFonts();

    protected abstract void renderDisplay(Graphics var1);

    public void refresh() {
        SwingUtilities.invokeLater(this.refresher);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.width * this.scaling, this.height * this.scaling);
        if (this.computer.getRunningStatus() == 0 || this.computer.getRunningStatus() == 1) {
            this.renderDisplay(g);
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void loadState(StateSet ss) {
    }

    @Override
    public void saveState(StateSet ss) {
    }

    private class Refresher
    implements Runnable {
        private Refresher() {
        }

        @Override
        public void run() {
            AbstractDisplay.this.paintImmediately(0, 0, AbstractDisplay.this.width * AbstractDisplay.this.scaling, AbstractDisplay.this.height * AbstractDisplay.this.scaling);
        }
    }
}

