/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import jp.asamomiji.emulator.AddressRegion;
import jp.asamomiji.emulator.MemorySystem;

public class Program {
    private MemorySystem ms = null;
    private String name = "";
    private String comment = "";
    private boolean basicArea = false;
    private ArrayList<AddressRegion> regions = new ArrayList();
    private File file = null;

    public Program(MemorySystem ms) {
        this.ms = ms;
    }

    public MemorySystem getMemorySystem() {
        return this.ms;
    }

    public void setName(String name) {
        this.name = Objects.toString(name, "");
    }

    public String getName() {
        return this.name;
    }

    public void setBasicArea(boolean value) {
        this.basicArea = value;
    }

    public boolean hasBasicArea() {
        return this.basicArea;
    }

    public void addAddressRegion(int start, int end) {
        this.regions.add(new AddressRegion(start, end));
    }

    public void addAddressRegion(int start, int end, String comment) {
        this.regions.add(new AddressRegion(start, end, comment));
    }

    public void addAddressRegion(AddressRegion a) {
        this.regions.add(a);
    }

    public void setComment(String comment) {
        this.comment = Objects.toString(comment, "");
    }

    public String getComment() {
        return this.comment;
    }

    public ArrayList<AddressRegion> getAllAddressRegions() {
        return this.regions;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        sb.append(this.getComment());
        sb.append(") ");
        sb.append("hasBasic=");
        sb.append(this.basicArea);
        sb.append(", file=");
        sb.append(this.file.getAbsolutePath());
        sb.append(", ");
        sb.append(this.regions.toString());
        return sb.toString();
    }
}

