/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.device.gamepad.AxisDialogKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.AxisKeyboardKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.ButtonDialogKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.ButtonKeyboardKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.ComponentStatus;
import jp.asamomiji.emulator.device.gamepad.Gamepad;
import jp.asamomiji.emulator.device.gamepad.KeyProcessor;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public class InputDeviceConfigurationDialog
extends JDialog {
    private Computer computer;
    private Gamepad gamepad;
    private int selected_axis;
    private final JPanel contentPanel = new JPanel();
    private JCheckBox checkBox_use_gamepad;
    private ArrayList<Controller> foundControllers;
    private JComboBox<Controller> comboBox_devices;
    private JRadioButton radioButton_keyboard;
    private JRadioButton radioButton_native;
    private ButtonGroup buttonGroup_mapping_mode = new ButtonGroup();
    private JRadioButton rdbtn_xy;
    private JRadioButton rdbtn_rxry;
    private JRadioButton rdbtn_zrz;
    private JRadioButton rdbtn_pov;
    private ButtonGroup buttonGroup_axes_used = new ButtonGroup();
    private JPanel panel_actualbuttons;
    private AxisDialogKeyProcessor axisProcessor = null;
    private ButtonDialogKeyProcessor buttonProcessor = null;
    private JButton[] button_axes = new JButton[8];
    private JButton[] button_buttons = new JButton[32];
    private ComponentStatus[] axisMapping;
    private ComponentStatus[] buttonMapping;
    private boolean saveduseGamepad;
    private KeyProcessor savedAxisKeyProcessor;
    private KeyProcessor savedButtonKeyProcessor;
    private int savedAxisUsed;
    private Controller savedController;
    private HashMap<JButton, ComponentStatus> componentStatusMap = new HashMap();
    private JTextField textField_button_number;
    private JTextField textField_button_keycode;
    private final Action actionOk = new SwingActionOk();
    private final Action actionCancel = new SwingActionCancel();
    private JTextField textField_axis_direction;
    private JTextField textField_axis_keycode;
    private final Action actionApply = new SwingActionApply();

    public InputDeviceConfigurationDialog(Computer computer, Frame owner) {
        this.computer = computer;
        this.gamepad = computer.getHardware().getGamepad();
        this.savedAxisKeyProcessor = this.gamepad.getAxisKeyProcessor();
        this.saveduseGamepad = Gamepad.getPropertyOfGamepadUse();
        this.savedButtonKeyProcessor = this.gamepad.getButtonKeyProcessor();
        this.savedAxisUsed = Gamepad.getPropertyOfGamepadAxisUsed();
        this.savedController = this.gamepad.getController();
        this.setTitle("\u5165\u529b\u30c7\u30d0\u30a4\u30b9\u306e\u8a2d\u5b9a");
        this.setBounds(100, 100, 724, 535);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((java.awt.Component)this.contentPanel, "Center");
        this.axisMapping = Gamepad.getPropertyOfGamepadAxisMapping();
        this.buttonMapping = Gamepad.getPropertyOfGamepadButtonMapping();
        this.checkBox_use_gamepad = new JCheckBox("\u30b2\u30fc\u30e0\u30d1\u30c3\u30c9\u3092\u4f7f\u7528\u3059\u308b\u3002");
        this.checkBox_use_gamepad.setSelected(Gamepad.getPropertyOfGamepadUse());
        JLabel label_device = new JLabel("\u30c7\u30d0\u30a4\u30b9");
        JScrollPane scrollPane = new JScrollPane();
        JLabel label_mapping = new JLabel("\u30de\u30c3\u30d4\u30f3\u30b0\u30e2\u30fc\u30c9");
        label_mapping.setVisible(false);
        this.radioButton_keyboard = new JRadioButton("\u30ad\u30fc\u30dc\u30fc\u30c9\u30de\u30c3\u30d4\u30f3\u30b0");
        this.radioButton_keyboard.setVisible(false);
        this.radioButton_native = new JRadioButton("\u30cd\u30a4\u30c6\u30a3\u30d6\u30de\u30c3\u30d4\u30f3\u30b0");
        this.radioButton_native.setVisible(false);
        this.buttonGroup_mapping_mode.add(this.radioButton_keyboard);
        this.buttonGroup_mapping_mode.add(this.radioButton_native);
        this.radioButton_keyboard.setSelected(true);
        JPanel panel_axis = new JPanel();
        panel_axis.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "\u8ef8", 4, 2, null, null));
        JPanel panel__button = new JPanel();
        panel__button.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "\u30dc\u30bf\u30f3", 4, 2, null, null));
        JTextArea txtrAltbackspace = new JTextArea();
        txtrAltbackspace.setEditable(false);
        txtrAltbackspace.setLineWrap(true);
        txtrAltbackspace.setText("Alt\u3092\u62bc\u3057\u306a\u304c\u3089\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u672a\u4f7f\u7528\u72b6\u614b\u3068\u4f7f\u7528\u72b6\u614b\u3092\u9078\u629e\u3067\u304d\u307e\u3059\u3002Backspace\u30ad\u30fc\u3092\u62bc\u3059\u3068\u30ad\u30fc\u304c\u672a\u5272\u308a\u5f53\u3066\u72b6\u614b\u306b\u306a\u308a\u307e\u3059\u3002");
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(txtrAltbackspace, 0, 0, Short.MAX_VALUE).addComponent(panel_axis, -2, 330, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE).addComponent(panel__button, -2, 338, -2)).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkBox_use_gamepad).addGroup(gl_contentPanel.createSequentialGroup().addComponent(label_device).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(scrollPane, -2, 412, -2)).addGroup(gl_contentPanel.createSequentialGroup().addComponent(label_mapping).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButton_keyboard).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.radioButton_native))).addContainerGap(244, Short.MAX_VALUE)));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addComponent(this.checkBox_use_gamepad).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(scrollPane, -2, -1, -2).addComponent(label_device, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_mapping).addComponent(this.radioButton_keyboard).addComponent(this.radioButton_native)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 213, Short.MAX_VALUE).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addGroup(gl_contentPanel.createSequentialGroup().addComponent(panel_axis, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(txtrAltbackspace, -2, 66, -2)).addComponent(panel__button, -2, 280, -2)).addContainerGap()));
        this.panel_actualbuttons = new JPanel();
        JPanel panel_1 = new JPanel();
        GroupLayout gl_panel__button = new GroupLayout(panel__button);
        gl_panel__button.setHorizontalGroup(gl_panel__button.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel__button.createSequentialGroup().addGroup(gl_panel__button.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(panel_1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.panel_actualbuttons, GroupLayout.Alignment.LEADING, -2, 314, -2)).addContainerGap()));
        gl_panel__button.setVerticalGroup(gl_panel__button.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_panel__button.createSequentialGroup().addContainerGap().addComponent(this.panel_actualbuttons, -2, 143, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(panel_1, -2, 88, -2).addGap(18)));
        this.panel_actualbuttons.setLayout(new FlowLayout(0, 5, 5));
        JLabel label_1 = new JLabel("\u30ad\u30fc\u5272\u308a\u5f53\u3066");
        JLabel label_2 = new JLabel("\u30dc\u30bf\u30f3");
        this.textField_button_number = new JTextField();
        this.textField_button_number.setEditable(false);
        this.textField_button_number.setColumns(10);
        JLabel label_3 = new JLabel("\u30ad\u30fc");
        this.textField_button_keycode = new JTextField();
        this.textField_button_keycode.setEditable(false);
        this.textField_button_keycode.setColumns(10);
        GroupLayout gl_panel_1 = new GroupLayout(panel_1);
        gl_panel_1.setHorizontalGroup(gl_panel_1.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_1.createSequentialGroup().addGroup(gl_panel_1.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(label_1).addGroup(gl_panel_1.createSequentialGroup().addComponent(label_2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField_button_number, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(label_3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField_button_keycode, -2, 60, -2))).addContainerGap(151, Short.MAX_VALUE)));
        gl_panel_1.setVerticalGroup(gl_panel_1.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_1.createSequentialGroup().addComponent(label_1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel_1.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label_2).addComponent(this.textField_button_number, -2, -1, -2).addComponent(label_3).addComponent(this.textField_button_keycode, -2, -1, -2)).addContainerGap(26, Short.MAX_VALUE)));
        panel_1.setLayout(gl_panel_1);
        panel__button.setLayout(gl_panel__button);
        JPanel panel_stick = new JPanel();
        panel_stick.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "\u4f7f\u3046\u8ef8", 4, 2, null, new Color(0, 0, 0)));
        JPanel panel_padbuttons = new JPanel();
        JLabel label = new JLabel("\u30dc\u30bf\u30f3");
        this.textField_axis_direction = new JTextField();
        this.textField_axis_direction.setEditable(false);
        this.textField_axis_direction.setColumns(10);
        JLabel label_4 = new JLabel("\u30ad\u30fc");
        this.textField_axis_keycode = new JTextField();
        this.textField_axis_keycode.setEditable(false);
        this.textField_axis_keycode.setColumns(10);
        GroupLayout gl_panel_axis = new GroupLayout(panel_axis);
        gl_panel_axis.setHorizontalGroup(gl_panel_axis.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_axis.createSequentialGroup().addComponent(panel_stick, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_panel_axis.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_axis.createSequentialGroup().addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField_axis_direction, -2, 40, -2).addGap(18).addComponent(label_4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textField_axis_keycode, -2, 60, -2)).addComponent(panel_padbuttons, -2, 201, -2)).addGap(26)));
        gl_panel_axis.setVerticalGroup(gl_panel_axis.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_axis.createSequentialGroup().addGroup(gl_panel_axis.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(panel_stick, -2, 120, -2).addComponent(panel_padbuttons, -2, 191, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(gl_panel_axis.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(label).addComponent(this.textField_axis_direction, -2, -1, -2).addComponent(label_4).addComponent(this.textField_axis_keycode, -2, -1, -2)).addContainerGap()));
        panel_padbuttons.setLayout(new GridLayout(0, 3, 0, 0));
        this.rdbtn_xy = new JRadioButton("x/y");
        this.rdbtn_xy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDeviceConfigurationDialog.this.selected_axis = 0;
                InputDeviceConfigurationDialog.this.gamepad.setAxisType(0);
                InputDeviceConfigurationDialog.this.axisProcessor.recalcMapping();
            }
        });
        this.rdbtn_rxry = new JRadioButton("rx/ry");
        this.rdbtn_rxry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDeviceConfigurationDialog.this.selected_axis = 1;
                InputDeviceConfigurationDialog.this.gamepad.setAxisType(1);
                InputDeviceConfigurationDialog.this.axisProcessor.recalcMapping();
            }
        });
        this.rdbtn_zrz = new JRadioButton("z/rz");
        this.rdbtn_zrz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDeviceConfigurationDialog.this.selected_axis = 2;
                InputDeviceConfigurationDialog.this.gamepad.setAxisType(2);
                InputDeviceConfigurationDialog.this.axisProcessor.recalcMapping();
            }
        });
        this.rdbtn_pov = new JRadioButton("POV");
        this.rdbtn_pov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputDeviceConfigurationDialog.this.selected_axis = 3;
                InputDeviceConfigurationDialog.this.gamepad.setAxisType(3);
                InputDeviceConfigurationDialog.this.axisProcessor.recalcMapping();
            }
        });
        this.buttonGroup_axes_used.add(this.rdbtn_xy);
        this.buttonGroup_axes_used.add(this.rdbtn_rxry);
        this.buttonGroup_axes_used.add(this.rdbtn_zrz);
        this.buttonGroup_axes_used.add(this.rdbtn_pov);
        switch (Gamepad.getPropertyOfGamepadAxisUsed()) {
            case 0: {
                this.rdbtn_xy.setSelected(true);
                this.gamepad.setAxisType(0);
                break;
            }
            case 1: {
                this.rdbtn_rxry.setSelected(true);
                this.gamepad.setAxisType(1);
                break;
            }
            case 2: {
                this.rdbtn_zrz.setSelected(true);
                this.gamepad.setAxisType(2);
                break;
            }
            case 3: {
                this.rdbtn_pov.setSelected(true);
                this.gamepad.setAxisType(3);
                break;
            }
            default: {
                this.rdbtn_xy.setSelected(true);
                this.gamepad.setAxisType(0);
            }
        }
        GroupLayout gl_panel_stick = new GroupLayout(panel_stick);
        gl_panel_stick.setHorizontalGroup(gl_panel_stick.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_stick.createSequentialGroup().addGroup(gl_panel_stick.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rdbtn_xy).addComponent(this.rdbtn_rxry).addComponent(this.rdbtn_zrz).addComponent(this.rdbtn_pov)).addContainerGap(-1, Short.MAX_VALUE)));
        gl_panel_stick.setVerticalGroup(gl_panel_stick.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_panel_stick.createSequentialGroup().addComponent(this.rdbtn_xy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtn_rxry).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtn_zrz).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdbtn_pov).addContainerGap(15, Short.MAX_VALUE)));
        panel_stick.setLayout(gl_panel_stick);
        panel_axis.setLayout(gl_panel_axis);
        this.comboBox_devices = new JComboBox();
        scrollPane.setViewportView(this.comboBox_devices);
        this.comboBox_devices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputDeviceConfigurationDialog.this.updateControllerProperty((Controller)InputDeviceConfigurationDialog.this.foundControllers.get(InputDeviceConfigurationDialog.this.comboBox_devices.getSelectedIndex()));
            }
        });
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((java.awt.Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setAction(this.actionOk);
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setAction(this.actionCancel);
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        JButton applyButton = new JButton("\u9069\u7528");
        applyButton.setAction(this.actionApply);
        buttonPane.add(applyButton);
        int i = 0;
        while (i < 8) {
            if (i == 4) {
                JLabel label_center = new JLabel("\u3007");
                label_center.setHorizontalAlignment(0);
                panel_padbuttons.add(label_center);
            }
            this.button_axes[i] = new JButton();
            this.button_axes[i].setMargin(new Insets(0, 0, 0, 0));
            if (this.axisMapping[i].getStatus() == 1) {
                this.button_axes[i].setBackground(Color.DARK_GRAY);
            } else {
                this.button_axes[i].setBackground(Color.LIGHT_GRAY);
            }
            this.button_axes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    ComponentStatus status = (ComponentStatus)InputDeviceConfigurationDialog.this.componentStatusMap.get(button);
                    int modifiers = e.getModifiers();
                    switch (status.getIndex()) {
                        case 0: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u5de6\u4e0a");
                            break;
                        }
                        case 1: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u4e0a");
                            break;
                        }
                        case 2: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u53f3\u4e0a");
                            break;
                        }
                        case 3: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u5de6");
                            break;
                        }
                        case 4: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u53f3");
                            break;
                        }
                        case 5: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u5de6\u4e0b");
                            break;
                        }
                        case 6: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u4e0b");
                            break;
                        }
                        case 7: {
                            InputDeviceConfigurationDialog.this.textField_axis_direction.setText("\u53f3\u4e0b");
                            break;
                        }
                    }
                    InputDeviceConfigurationDialog.this.textField_axis_keycode.setText(status.getKeyText());
                    if ((modifiers & 8) == 8) {
                        if (status.getStatus() != 1) {
                            status.setStatus(1);
                            button.setBackground(Color.DARK_GRAY);
                        } else {
                            status.setStatus(2);
                            button.setBackground(Color.LIGHT_GRAY);
                        }
                        InputDeviceConfigurationDialog.this.axisProcessor.recalcMapping();
                    }
                }
            });
            this.button_axes[i].addKeyListener(new KeyAdapterForButton(this.button_axes[i], this.axisMapping[i], this.textField_axis_keycode));
            this.componentStatusMap.put(this.button_axes[i], this.axisMapping[i]);
            panel_padbuttons.add(this.button_axes[i]);
            ++i;
        }
        i = 0;
        while (i < 32) {
            this.buttonMapping[i].setIndex(i);
            this.button_buttons[i] = new RoundButton();
            this.button_buttons[i].setEnabled(false);
            this.panel_actualbuttons.add(this.button_buttons[i]);
            this.button_buttons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JButton button = (JButton)e.getSource();
                    ComponentStatus status = (ComponentStatus)InputDeviceConfigurationDialog.this.componentStatusMap.get(button);
                    int modifiers = e.getModifiers();
                    InputDeviceConfigurationDialog.this.textField_button_number.setText(Integer.toString(status.getIndex()));
                    InputDeviceConfigurationDialog.this.textField_button_keycode.setText(status.getKeyText());
                    if ((modifiers & 8) == 8) {
                        if (status.getStatus() != 1) {
                            status.setStatus(1);
                            button.setBackground(Color.DARK_GRAY);
                        } else {
                            status.setStatus(2);
                            button.setBackground(Color.LIGHT_GRAY);
                        }
                    }
                }
            });
            this.button_buttons[i].addKeyListener(new KeyAdapterForButton(this.button_buttons[i], this.buttonMapping[i], this.textField_button_keycode));
            this.componentStatusMap.put(this.button_buttons[i], this.buttonMapping[i]);
            ++i;
        }
        this.foundControllers = this.gamepad.scanControllers();
        if (this.foundControllers.isEmpty()) {
            this.checkBox_use_gamepad.setEnabled(false);
        } else {
            boolean selected = false;
            for (Controller c : this.foundControllers) {
                this.comboBox_devices.addItem(c);
                if (!c.getName().equals(Gamepad.getPropertyOfGamepadName())) continue;
                this.comboBox_devices.setSelectedItem(c);
                selected = true;
            }
            if (!selected) {
                this.comboBox_devices.setSelectedIndex(0);
                selected = true;
            }
            Controller controller = this.foundControllers.get(this.comboBox_devices.getSelectedIndex());
            this.updateControllerProperty(controller);
        }
    }

    private void updateControllerProperty(Controller controller) {
        int button_count = 0;
        boolean has_x = false;
        boolean has_y = false;
        boolean has_rx = false;
        boolean has_ry = false;
        boolean has_z = false;
        boolean has_rz = false;
        boolean has_pov = false;
        Component[] components = controller.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i].getIdentifier().getName().equals("x")) {
                has_x = true;
            } else if (components[i].getIdentifier().getName().equals("y")) {
                has_y = true;
            } else if (components[i].getIdentifier().getName().equals("rx")) {
                has_rx = true;
            } else if (components[i].getIdentifier().getName().equals("ry")) {
                has_ry = true;
            } else if (components[i].getIdentifier().getName().equals("z")) {
                has_z = true;
            } else if (components[i].getIdentifier().getName().equals("rz")) {
                has_rz = true;
            } else if (components[i].getIdentifier().getName().equals("rz")) {
                has_rz = true;
            } else if (components[i].getIdentifier().getName().equals("pov")) {
                has_pov = true;
            } else if (components[i].getIdentifier() instanceof Component.Identifier.Button) {
                ++button_count;
            }
            ++i;
        }
        if (has_x && has_y) {
            this.rdbtn_xy.setEnabled(true);
        } else {
            this.rdbtn_xy.setEnabled(false);
        }
        if (has_rx && has_ry) {
            this.rdbtn_rxry.setEnabled(true);
        } else {
            this.rdbtn_rxry.setEnabled(false);
        }
        if (has_z && has_rz) {
            this.rdbtn_zrz.setEnabled(true);
        } else {
            this.rdbtn_zrz.setEnabled(false);
        }
        if (has_pov) {
            this.rdbtn_pov.setEnabled(true);
        } else {
            this.rdbtn_pov.setEnabled(false);
        }
        i = 0;
        while (i < 8) {
            this.button_axes[i].setText(this.axisMapping[i].getKeyText());
            ++i;
        }
        this.axisProcessor = new AxisDialogKeyProcessor(this.gamepad, this.axisMapping, this.button_axes);
        this.gamepad.setAxisKeyProcessor(this.axisProcessor);
        i = 0;
        while (i < 32) {
            ComponentStatus status = this.componentStatusMap.get(this.button_buttons[i]);
            if (i < button_count) {
                this.button_buttons[i].setEnabled(true);
                this.button_buttons[i].setVisible(true);
                this.button_buttons[i].setBackground(Color.LIGHT_GRAY);
            } else {
                this.button_buttons[i].setEnabled(false);
                this.button_buttons[i].setVisible(false);
            }
            this.button_buttons[i].setText(status.getKeyText());
            ++i;
        }
        this.buttonProcessor = new ButtonDialogKeyProcessor(this.gamepad, this.buttonMapping, this.button_buttons);
        this.gamepad.setButtonKeyProcessor(this.buttonProcessor);
        this.gamepad.restart(controller);
    }

    private boolean applyAll() {
        boolean use_gamepad = this.checkBox_use_gamepad.isSelected();
        if (use_gamepad && this.foundControllers.size() == 0) {
            JOptionPane.showMessageDialog(null, "\u30b2\u30fc\u30e0\u30d1\u30c3\u30c9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", "ERROR", 0);
            return false;
        }
        Gamepad.setPropertyOfGamepadUse(use_gamepad);
        if (!use_gamepad) {
            this.gamepad.restart(null);
            return true;
        }
        Controller c = this.foundControllers.get(this.comboBox_devices.getSelectedIndex());
        Gamepad.setPropertyOfGamepadName(c.getName());
        if (this.radioButton_keyboard.isSelected()) {
            Gamepad.setPropertyOfGamepadMappingMode(0);
        } else {
            Gamepad.setPropertyOfGamepadMappingMode(1);
        }
        Gamepad.setPropertyOfGamepadAxisUsed(this.selected_axis);
        Gamepad.setPropertyOfGamepadAxisMapping(this.axisMapping);
        Gamepad.setPropertyOfGamepadButtonMapping(this.buttonMapping);
        this.gamepad.setAxisKeyProcessor(new AxisKeyboardKeyProcessor(this.gamepad, this.axisMapping, this.computer.getHardware().getKeyboard()));
        this.gamepad.setButtonKeyProcessor(new ButtonKeyboardKeyProcessor(this.gamepad, this.buttonMapping, this.computer.getHardware().getKeyboard()));
        this.gamepad.restart(c);
        return true;
    }

    private class KeyAdapterForButton
    extends KeyAdapter {
        private AbstractButton parent;
        private ComponentStatus status;
        private JTextField keytext;

        KeyAdapterForButton(AbstractButton parent, ComponentStatus status, JTextField keytext) {
            this.parent = parent;
            this.status = status;
            this.keytext = keytext;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.parent.hasFocus()) {
                if (e.getKeyCode() == 8) {
                    this.status.setStatus(2);
                    this.status.setKeyCode(0);
                    this.parent.setText("\u672a\u5272\u5f53");
                    this.keytext.setText("\u672a\u5272\u5f53");
                } else if (e.getKeyCode() != 18 && this.status.getStatus() != 1) {
                    this.status.setKeyCode(e.getKeyCode());
                    this.parent.setText(KeyEvent.getKeyText(e.getKeyCode()));
                    this.keytext.setText(KeyEvent.getKeyText(e.getKeyCode()));
                }
            }
        }
    }

    private class RoundButton
    extends JButton {
        protected Shape base;
        protected Shape shape;
        protected Shape border;
        protected final Color fc = new Color(100, 150, 255, 200);
        protected final Color ac = new Color(230, 230, 230);
        protected final Color rc = Color.ORANGE;
        protected static final int focusstroke = 2;

        public RoundButton() {
            this.setFocusPainted(true);
            this.initShape();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = 30;
            d.width = 30;
            return d;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setBackground(new Color(250, 250, 250));
            this.initShape();
        }

        protected void initShape() {
            if (!this.getBounds().equals(this.base)) {
                this.base = this.getBounds();
                this.shape = new Ellipse2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1);
                this.border = new Ellipse2D.Float(2.0f, 2.0f, this.getWidth() - 1 - 4, this.getHeight() - 1 - 4);
            }
        }

        private void paintFocusAndRollover(Graphics2D g2, Color color) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, color, this.getWidth() - 1, this.getHeight() - 1, color.brighter(), true));
            g2.fill(this.shape);
            g2.setColor(this.getBackground());
            g2.fill(this.border);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.initShape();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.getModel().isArmed()) {
                g2.setColor(this.ac);
                g2.fill(this.shape);
            } else if (this.isRolloverEnabled() && this.getModel().isRollover()) {
                this.paintFocusAndRollover(g2, this.rc);
            } else if (this.hasFocus()) {
                this.paintFocusAndRollover(g2, this.fc);
            } else {
                g2.setColor(this.getBackground());
                g2.fill(this.shape);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setColor(this.getBackground());
            super.paintComponent(g2);
            g2.dispose();
        }

        @Override
        protected void paintBorder(Graphics g) {
            this.initShape();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.getForeground());
            g2.draw(this.shape);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.dispose();
        }

        @Override
        public boolean contains(int x, int y) {
            this.initShape();
            return this.shape == null ? false : this.shape.contains(x, y);
        }
    }

    private class SwingActionApply
    extends AbstractAction {
        public SwingActionApply() {
            this.putValue("Name", "\u9069\u7528");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3059\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputDeviceConfigurationDialog.this.applyAll();
            InputDeviceConfigurationDialog.this.savedAxisKeyProcessor = InputDeviceConfigurationDialog.this.gamepad.getAxisKeyProcessor();
            InputDeviceConfigurationDialog.this.saveduseGamepad = Gamepad.getPropertyOfGamepadUse();
            InputDeviceConfigurationDialog.this.savedButtonKeyProcessor = InputDeviceConfigurationDialog.this.gamepad.getButtonKeyProcessor();
            InputDeviceConfigurationDialog.this.savedAxisUsed = Gamepad.getPropertyOfGamepadAxisUsed();
            InputDeviceConfigurationDialog.this.savedController = InputDeviceConfigurationDialog.this.gamepad.getController();
            Controller controller = (Controller)InputDeviceConfigurationDialog.this.foundControllers.get(InputDeviceConfigurationDialog.this.comboBox_devices.getSelectedIndex());
            InputDeviceConfigurationDialog.this.updateControllerProperty(controller);
        }
    }

    private class SwingActionCancel
    extends AbstractAction {
        public SwingActionCancel() {
            this.putValue("Name", "\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u7121\u52b9\u306b\u3057\u3066\u9589\u3058\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Gamepad.setPropertyOfGamepadUse(InputDeviceConfigurationDialog.this.saveduseGamepad);
            InputDeviceConfigurationDialog.this.gamepad.setAxisKeyProcessor(InputDeviceConfigurationDialog.this.savedAxisKeyProcessor);
            InputDeviceConfigurationDialog.this.gamepad.setButtonKeyProcessor(InputDeviceConfigurationDialog.this.savedButtonKeyProcessor);
            InputDeviceConfigurationDialog.this.gamepad.setAxisType(InputDeviceConfigurationDialog.this.savedAxisUsed);
            InputDeviceConfigurationDialog.this.gamepad.restart(InputDeviceConfigurationDialog.this.savedController);
            InputDeviceConfigurationDialog.this.dispose();
        }
    }

    private class SwingActionOk
    extends AbstractAction {
        public SwingActionOk() {
            this.putValue("Name", "Ok");
            this.putValue("ShortDescription", "\u8a2d\u5b9a\u3092\u6709\u52b9\u306b\u3057\u3066\u9589\u3058\u308b\u3002");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InputDeviceConfigurationDialog.this.applyAll();
            InputDeviceConfigurationDialog.this.dispose();
        }
    }
}

