/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import jp.asamomiji.emulator.Addressable;
import jp.asamomiji.emulator.Computer;

public class ExtendedIOPort
implements Addressable {
    protected Computer computer;
    private int startAddr;
    private int endAddr;
    private byte gamepadStatus = 0;

    public ExtendedIOPort(Computer computer, int start) {
        this.computer = computer;
        this.startAddr = start;
        this.endAddr = start + 1023;
    }

    @Override
    public int getStartAddress() {
        return this.startAddr;
    }

    @Override
    public int getEndAddress() {
        return this.endAddr;
    }

    @Override
    public byte load8(int address) {
        if (address == 52226) {
            return this.gamepadStatus;
        }
        return 0;
    }

    @Override
    public void store8(int address, byte value) {
        if (address == 52226) {
            this.gamepadStatus = value;
        }
    }

    @Override
    public short load16(int address) {
        if (address == 52225) {
            return (short)(this.gamepadStatus & 0xFF);
        }
        if (address == 52226) {
            return (short)(this.gamepadStatus << 8 & 0xFF00);
        }
        return 0;
    }

    @Override
    public void store16(int address, short value) {
    }
}

