/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.jr100;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.asamomiji.assembler.Disassembler;
import jp.asamomiji.emulator.Computer;

public class DisassembleDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Computer computer = null;
    private JPanel jContentPane = null;
    private JScrollPane SP_main = null;
    private JTextArea TA_main = null;
    private JPanel P_option = null;
    private JLabel L_address = null;
    private JTextField TF_start = null;
    private JTextField TF_end = null;
    private JButton BT_execute = null;

    public DisassembleDialog(Computer computer, Frame owner) {
        super(owner);
        this.computer = computer;
        this.initialize();
    }

    private void initialize() {
        this.setSize(350, 457);
        this.setTitle("\u9006\u30a2\u30bb\u30f3\u30d6\u30eb");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.setSize(new Dimension(265, 272));
            this.jContentPane.add((Component)this.getSP_main(), null);
            this.jContentPane.add((Component)this.getP_option(), null);
        }
        return this.jContentPane;
    }

    private JScrollPane getSP_main() {
        if (this.SP_main == null) {
            this.SP_main = new JScrollPane();
            this.SP_main.setViewportView(this.getTA_main());
        }
        return this.SP_main;
    }

    private JTextArea getTA_main() {
        if (this.TA_main == null) {
            this.TA_main = new JTextArea();
            this.TA_main.setFont(new Font("Monospaced", 0, 12));
            this.TA_main.setEditable(false);
        }
        return this.TA_main;
    }

    private JPanel getP_option() {
        if (this.P_option == null) {
            this.L_address = new JLabel();
            this.L_address.setText("\u30a2\u30c9\u30ec\u30b9");
            this.P_option = new JPanel();
            this.P_option.setLayout(new BoxLayout(this.getP_option(), 0));
            this.P_option.add((Component)this.L_address, null);
            this.P_option.add((Component)this.getTF_start(), null);
            this.P_option.add((Component)this.getTF_end(), null);
            this.P_option.add((Component)this.getBT_execute(), null);
        }
        return this.P_option;
    }

    private JTextField getTF_start() {
        if (this.TF_start == null) {
            this.TF_start = new JTextField();
            this.TF_start.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        }
        return this.TF_start;
    }

    private JTextField getTF_end() {
        if (this.TF_end == null) {
            this.TF_end = new JTextField();
            this.TF_end.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        }
        return this.TF_end;
    }

    private JButton getBT_execute() {
        if (this.BT_execute == null) {
            this.BT_execute = new JButton();
            this.BT_execute.setText("\u5b9f\u884c");
            this.BT_execute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int start = Integer.parseInt(DisassembleDialog.this.TF_start.getText(), 16);
                    int end = Integer.parseInt(DisassembleDialog.this.TF_end.getText(), 16);
                    Disassembler da = new Disassembler(DisassembleDialog.this.computer.getHardware().getMemory(), start, end);
                    da.execute();
                    DisassembleDialog.this.TA_main.setText(da.print());
                    DisassembleDialog.this.TA_main.setCaretPosition(0);
                }
            });
        }
        return this.BT_execute;
    }
}

