/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.device.gamepad;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Device;
import jp.asamomiji.emulator.device.gamepad.ComponentStatus;
import jp.asamomiji.emulator.device.gamepad.KeyProcessor;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class Gamepad
extends Thread
implements Device {
    public static final String PROPERTY_GAMEPAD_USE = "jr100.input.gamepad.use";
    public static final String PROPERTY_GAMEPAD_NAME = "jr100.input.gamepad.name";
    public static final String PROPERTY_GAMEPAD_MAPPING_MODE = "jr100.input.gamepad.mapping_mode";
    public static final String PROPERTY_GAMEPAD_AXIS_USED = "jr100.input.gamepad.axis_used";
    public static final String PROPERTY_GAMEPAD_AXIS_MAPPING = "jr100.input.gamepad.axis_mapping";
    public static final String PROPERTY_GAMEPAD_BUTTON_MAPPING = "jr100.input.gamepad.button_mapping";
    public static final int GAMEPAD_MAX_NUMBER_OF_BUTTONS = 32;
    public static final int MODE_UNDEFINED = -1;
    public static final int MODE_KEYBOARD = 0;
    public static final int MODE_NATIVE = 1;
    public static final int AXIS_UNDEFINED = -1;
    public static final int AXIS_XY = 0;
    public static final int AXIS_RXRY = 1;
    public static final int AXIS_ZRZ = 2;
    public static final int AXIS_POV = 3;
    public static final int GAMEPAD_NUMBER_OF_DIRECTIONS = 8;
    public static final int DIR_UP_LEFT = 0;
    public static final int DIR_UP = 1;
    public static final int DIR_UP_RIGHT = 2;
    public static final int DIR_LEFT = 3;
    public static final int DIR_RIGHT = 4;
    public static final int DIR_DOWN_LEFT = 5;
    public static final int DIR_DOWN = 6;
    public static final int DIR_DOWN_RIGHT = 7;
    public static final int DIR_NEUTRAL = 8;
    public static final int DIR_ERROR = 9;
    public static final int BUTTON_PRESSED = 100;
    public static final int BUTTON_RELEASED = 101;
    public static final int GAMEPAD_NUMBER_OF_ACTIONS = 10;
    public static final int ACT_LEFT = 0;
    public static final int ACT_X_NEUTRAL = 1;
    public static final int ACT_RIGHT = 2;
    public static final int ACT_UP = 3;
    public static final int ACT_Y_NEUTRAL = 4;
    public static final int ACT_DOWN = 5;
    public static final int ACT_UP_LEFT = 6;
    public static final int ACT_UP_RIGHT = 7;
    public static final int ACT_DOWN_LEFT = 8;
    public static final int ACT_DOWN_RIGHT = 9;
    public static final int ACT_ORIGIN = 10;
    public static final int ACT_ERROR = 11;
    private static final int STATUS_STOPPED = 0;
    private static final int STATUS_SUSPENDED = 1;
    private static final int STATUS_RUNNING = 2;
    private static final float THRESHOLD = 0.5f;
    private Computer computer;
    private Controller controller = null;
    private volatile boolean suspendRequested = false;
    private int status = 0;
    private int direction = 8;
    private int selectedAxisType;
    private KeyProcessor axisKeyProcessor = null;
    private KeyProcessor buttonKeyProcessor = null;
    private int currentState = 8;
    private static final int S_UL = 0;
    private static final int S_UP = 1;
    private static final int S_UR = 2;
    private static final int S_LE = 3;
    private static final int S_RI = 4;
    private static final int S_DL = 5;
    private static final int S_DO = 6;
    private static final int S_DR = 7;
    private static final int S_NE = 8;
    private static final int S_ER = 9;
    private static int[][] stateTransitionTable;
    private static int[][] stateTransitionTable84;
    private static int[][] stateTransitionTableForPov;
    private HashMap<Component.Identifier, Integer> buttonNumber = new HashMap<Component.Identifier, Integer>(){
        {
            this.put(Component.Identifier.Button._0, 0);
            this.put(Component.Identifier.Button._1, 1);
            this.put(Component.Identifier.Button._2, 2);
            this.put(Component.Identifier.Button._3, 3);
            this.put(Component.Identifier.Button._4, 4);
            this.put(Component.Identifier.Button._5, 5);
            this.put(Component.Identifier.Button._6, 6);
            this.put(Component.Identifier.Button._7, 7);
            this.put(Component.Identifier.Button._8, 8);
            this.put(Component.Identifier.Button._9, 9);
            this.put(Component.Identifier.Button._10, 10);
            this.put(Component.Identifier.Button._11, 11);
            this.put(Component.Identifier.Button._12, 12);
            this.put(Component.Identifier.Button._13, 13);
            this.put(Component.Identifier.Button._14, 14);
            this.put(Component.Identifier.Button._15, 15);
            this.put(Component.Identifier.Button._16, 16);
            this.put(Component.Identifier.Button._17, 17);
            this.put(Component.Identifier.Button._18, 18);
            this.put(Component.Identifier.Button._19, 19);
            this.put(Component.Identifier.Button._20, 20);
            this.put(Component.Identifier.Button._21, 21);
            this.put(Component.Identifier.Button._22, 22);
            this.put(Component.Identifier.Button._23, 23);
            this.put(Component.Identifier.Button._24, 24);
            this.put(Component.Identifier.Button._25, 25);
            this.put(Component.Identifier.Button._26, 26);
            this.put(Component.Identifier.Button._27, 27);
            this.put(Component.Identifier.Button._28, 28);
            this.put(Component.Identifier.Button._29, 29);
            this.put(Component.Identifier.Button._30, 30);
            this.put(Component.Identifier.Button._31, 31);
        }
    };
    static int s;
    static int a;

    static {
        int[][] nArrayArray = new int[9][];
        nArrayArray[0] = new int[]{9, 1, 9, 9, 3, 9, 9, 9, 9, 9, 9};
        int[] nArray = new int[11];
        nArray[1] = 9;
        nArray[2] = 2;
        nArray[3] = 9;
        nArray[4] = 8;
        nArray[5] = 9;
        nArray[6] = 9;
        nArray[7] = 9;
        nArray[8] = 9;
        nArray[9] = 9;
        nArray[10] = 8;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{9, 1, 9, 9, 4, 9, 9, 9, 9, 9, 9};
        int[] nArray2 = new int[11];
        nArray2[0] = 9;
        nArray2[1] = 8;
        nArray2[2] = 9;
        nArray2[4] = 9;
        nArray2[5] = 5;
        nArray2[6] = 9;
        nArray2[7] = 9;
        nArray2[8] = 9;
        nArray2[9] = 9;
        nArray2[10] = 8;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[]{9, 8, 9, 2, 9, 7, 9, 9, 9, 9, 8};
        nArrayArray[5] = new int[]{9, 6, 9, 9, 3, 9, 9, 9, 9, 9, 9};
        nArrayArray[6] = new int[]{5, 9, 7, 9, 8, 9, 9, 9, 9, 9, 8};
        nArrayArray[7] = new int[]{9, 6, 9, 9, 4, 9, 9, 9, 9, 9, 9};
        nArrayArray[8] = new int[]{3, 9, 4, 1, 9, 6, 9, 9, 9, 9, 8};
        stateTransitionTable84 = nArrayArray;
        int[][] nArrayArray2 = new int[9][];
        nArrayArray2[0] = new int[]{3, 1, 9, 1, 3, 9, 9, 9, 9, 9, 8};
        int[] nArray3 = new int[11];
        nArray3[1] = 9;
        nArray3[2] = 2;
        nArray3[3] = 9;
        nArray3[4] = 8;
        nArray3[5] = 9;
        nArray3[7] = 2;
        nArray3[8] = 9;
        nArray3[9] = 9;
        nArray3[10] = 8;
        nArrayArray2[1] = nArray3;
        nArrayArray2[2] = new int[]{9, 1, 4, 1, 4, 9, 9, 9, 9, 9, 8};
        int[] nArray4 = new int[11];
        nArray4[0] = 9;
        nArray4[1] = 8;
        nArray4[2] = 9;
        nArray4[4] = 9;
        nArray4[5] = 5;
        nArray4[7] = 9;
        nArray4[8] = 5;
        nArray4[9] = 9;
        nArray4[10] = 8;
        nArrayArray2[3] = nArray4;
        nArrayArray2[4] = new int[]{9, 8, 9, 2, 9, 7, 9, 2, 9, 7, 8};
        nArrayArray2[5] = new int[]{3, 6, 9, 9, 3, 6, 9, 9, 9, 9, 8};
        nArrayArray2[6] = new int[]{5, 9, 7, 9, 8, 9, 9, 9, 5, 7, 8};
        nArrayArray2[7] = new int[]{9, 6, 4, 9, 4, 6, 9, 9, 9, 9, 8};
        nArrayArray2[8] = new int[]{3, 9, 4, 1, 9, 6, 9, 9, 9, 9, 8};
        stateTransitionTableForPov = nArrayArray2;
    }

    public Gamepad(Computer computer) {
        super("gamepad manager");
        this.computer = computer;
    }

    public void setAxisKeyProcessor(KeyProcessor akp) {
        this.axisKeyProcessor = akp;
    }

    public KeyProcessor getAxisKeyProcessor() {
        return this.axisKeyProcessor;
    }

    public void setButtonKeyProcessor(KeyProcessor kp) {
        this.buttonKeyProcessor = kp;
    }

    public KeyProcessor getButtonKeyProcessor() {
        return this.buttonKeyProcessor;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    public void dumpTable() {
        int i = 0;
        while (i < 9) {
            System.out.print(String.valueOf(i) + " : ");
            int j = 0;
            while (j < 11) {
                System.out.print(String.valueOf(stateTransitionTable[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void setAxisType(int type) {
        this.selectedAxisType = type;
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                stateTransitionTable = stateTransitionTable84;
                break;
            }
            case 3: {
                stateTransitionTable = stateTransitionTableForPov;
                break;
            }
            default: {
                stateTransitionTable = stateTransitionTable84;
            }
        }
    }

    public int getAxisType() {
        return this.selectedAxisType;
    }

    public int getDirection() {
        return this.direction;
    }

    public static void setPropertyOfGamepadUse(boolean value) {
        Application.getProperties().setProperty(PROPERTY_GAMEPAD_USE, Boolean.toString(value));
    }

    public static boolean getPropertyOfGamepadUse() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_USE);
        if (m == null) {
            return false;
        }
        return Boolean.parseBoolean(m);
    }

    public static void setPropertyOfGamepadName(String value) {
        Application.getProperties().setProperty(PROPERTY_GAMEPAD_NAME, value);
    }

    public static String getPropertyOfGamepadName() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_NAME);
        if (m == null) {
            return "";
        }
        return m;
    }

    public static void setPropertyOfGamepadMappingMode(int mode) {
        String mode_string;
        switch (mode) {
            case 0: {
                mode_string = "keyboard";
                break;
            }
            case 1: {
                mode_string = "native";
                break;
            }
            default: {
                mode_string = null;
            }
        }
        if (mode_string != null) {
            Application.getProperties().setProperty(PROPERTY_GAMEPAD_MAPPING_MODE, mode_string);
        }
    }

    public static int getPropertyOfGamepadMappingMode() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_MAPPING_MODE);
        if (m == null) {
            return 0;
        }
        if (m.equals("keyboard")) {
            return 0;
        }
        if (m.equals("native")) {
            return 1;
        }
        return -1;
    }

    public static void setPropertyOfGamepadAxisUsed(int mode) {
        String mode_string;
        switch (mode) {
            case 0: {
                mode_string = "xy";
                break;
            }
            case 1: {
                mode_string = "rxry";
                break;
            }
            case 2: {
                mode_string = "zrz";
                break;
            }
            case 3: {
                mode_string = "pov";
                break;
            }
            default: {
                mode_string = null;
            }
        }
        if (mode_string != null) {
            Application.getProperties().setProperty(PROPERTY_GAMEPAD_AXIS_USED, mode_string);
        }
    }

    public static int getPropertyOfGamepadAxisUsed() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_AXIS_USED);
        if (m == null) {
            return 0;
        }
        if (m.equals("xy")) {
            return 0;
        }
        if (m.equals("rxry")) {
            return 1;
        }
        if (m.equals("zrz")) {
            return 2;
        }
        if (m.equals("pov")) {
            return 3;
        }
        return -1;
    }

    public static void setPropertyOfGamepadAxisMapping(ComponentStatus[] mapping) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < mapping.length) {
            sb.append(Integer.toString(mapping[i].getKeyCode()));
            sb.append(" ");
            ++i;
        }
        Application.getProperties().setProperty(PROPERTY_GAMEPAD_AXIS_MAPPING, sb.toString());
    }

    public static ComponentStatus[] getPropertyOfGamepadAxisMapping() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_AXIS_MAPPING);
        ComponentStatus[] mapping = new ComponentStatus[8];
        if (m == null) {
            int i = 0;
            while (i < mapping.length) {
                mapping[i] = new ComponentStatus(i, 0);
                ++i;
            }
        } else {
            String[] splitted = m.split("\\s+", 0);
            int i = 0;
            while (i < Math.min(mapping.length, splitted.length)) {
                mapping[i] = new ComponentStatus(i, Integer.parseInt(splitted[i]));
                ++i;
            }
            i = Math.min(mapping.length, splitted.length);
            while (i < 8) {
                mapping[i] = new ComponentStatus(i, -1);
                ++i;
            }
        }
        return mapping;
    }

    public static void setPropertyOfGamepadButtonMapping(ComponentStatus[] mapping) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < mapping.length) {
            sb.append(Integer.toString(mapping[i].getKeyCode()));
            sb.append(" ");
            ++i;
        }
        Application.getProperties().setProperty(PROPERTY_GAMEPAD_BUTTON_MAPPING, sb.toString());
    }

    public static ComponentStatus[] getPropertyOfGamepadButtonMapping() {
        String m = Application.getProperties().getProperty(PROPERTY_GAMEPAD_BUTTON_MAPPING);
        ComponentStatus[] mapping = new ComponentStatus[32];
        if (m == null) {
            int i = 0;
            while (i < mapping.length) {
                mapping[i] = new ComponentStatus(i, 0);
                ++i;
            }
        } else {
            String[] splitted = m.split("\\s+", 0);
            int i = 0;
            while (i < Math.min(mapping.length, splitted.length)) {
                mapping[i] = new ComponentStatus(i, Integer.parseInt(splitted[i]));
                ++i;
            }
            i = Math.min(mapping.length, splitted.length);
            while (i < 8) {
                mapping[i] = new ComponentStatus(i, -1);
                ++i;
            }
        }
        return mapping;
    }

    private boolean loop() {
        while (!this.suspendRequested) {
            if (!this.controller.poll()) {
                return false;
            }
            EventQueue queue = this.controller.getEventQueue();
            Event event = new Event();
            while (queue.getNextEvent(event)) {
                Component c = event.getComponent();
                Component.Identifier id = c.getIdentifier();
                float v = c.getPollData();
                if (this.selectedAxisType == 0 && c.getIdentifier() == Component.Identifier.Axis.X || this.selectedAxisType == 1 && c.getIdentifier() == Component.Identifier.Axis.RX || this.selectedAxisType == 2 && c.getIdentifier() == Component.Identifier.Axis.Z) {
                    if (v < -0.5f) {
                        this.gamepadDirectionChanged(this.currentState, 0);
                        continue;
                    }
                    if (v > 0.5f) {
                        this.gamepadDirectionChanged(this.currentState, 2);
                        continue;
                    }
                    this.gamepadDirectionChanged(this.currentState, 1);
                    continue;
                }
                if (this.selectedAxisType == 0 && c.getIdentifier() == Component.Identifier.Axis.Y || this.selectedAxisType == 1 && c.getIdentifier() == Component.Identifier.Axis.RY || this.selectedAxisType == 2 && c.getIdentifier() == Component.Identifier.Axis.RZ) {
                    if (v < -0.5f) {
                        this.gamepadDirectionChanged(this.currentState, 3);
                        continue;
                    }
                    if (v > 0.5f) {
                        this.gamepadDirectionChanged(this.currentState, 5);
                        continue;
                    }
                    this.gamepadDirectionChanged(this.currentState, 4);
                    continue;
                }
                if (this.selectedAxisType == 3) {
                    if ((double)v < 0.0625) {
                        this.gamepadDirectionChanged(this.currentState, 10);
                        continue;
                    }
                    if ((double)v < 0.1875) {
                        this.gamepadDirectionChanged(this.currentState, 6);
                        continue;
                    }
                    if ((double)v < 0.3125) {
                        this.gamepadDirectionChanged(this.currentState, 3);
                        continue;
                    }
                    if ((double)v < 0.4375) {
                        this.gamepadDirectionChanged(this.currentState, 7);
                        continue;
                    }
                    if ((double)v < 0.5625) {
                        this.gamepadDirectionChanged(this.currentState, 2);
                        continue;
                    }
                    if ((double)v < 0.6875) {
                        this.gamepadDirectionChanged(this.currentState, 9);
                        continue;
                    }
                    if ((double)v < 0.8125) {
                        this.gamepadDirectionChanged(this.currentState, 5);
                        continue;
                    }
                    if ((double)v < 0.9375) {
                        this.gamepadDirectionChanged(this.currentState, 8);
                        continue;
                    }
                    this.gamepadDirectionChanged(this.currentState, 0);
                    continue;
                }
                if (!(id instanceof Component.Identifier.Button)) continue;
                if (v > 0.5f) {
                    this.gamepadButtonPressed(this.buttonNumber.get(id));
                    continue;
                }
                this.gamepadButtonReleased(this.buttonNumber.get(id));
            }
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        this.suspendRequested = false;
        return true;
    }

    public void requestSuspend() {
        this.suspendRequested = true;
    }

    public boolean waitForSuspended(long period, int count) {
        if (this.status == 2) {
            while (this.suspendRequested && count >= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                --count;
            }
            return !this.suspendRequested;
        }
        return this.status != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restart(Controller controller) {
        if (this.status == 0) {
            return false;
        }
        if (this.status == 2) {
            this.requestSuspend();
            if (!this.waitForSuspended(100L, 100)) {
                return false;
            }
        }
        this.setController(controller);
        Gamepad gamepad = this;
        synchronized (gamepad) {
            this.notify();
        }
        return true;
    }

    public ArrayList<Controller> scanControllers() {
        Controller[] candidates = ControllerEnvironment.getDefaultEnvironment().getControllers();
        ArrayList<Controller> found = new ArrayList<Controller>();
        int i = 0;
        while (i < candidates.length) {
            Controller controller = candidates[i];
            if (controller.getType() == Controller.Type.STICK || controller.getType() == Controller.Type.GAMEPAD) {
                found.add(controller);
            }
            ++i;
        }
        return found;
    }

    public Controller searchForController() {
        ArrayList<Controller> controllers = this.scanControllers();
        this.controller = null;
        for (Controller c : controllers) {
            if (!c.getName().equals(Gamepad.getPropertyOfGamepadName())) continue;
            this.controller = c;
        }
        return this.controller;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Gamepad gamepad = this;
            synchronized (gamepad) {
                while (true) {
                    if (Gamepad.getPropertyOfGamepadUse() && this.controller != null) {
                        this.status = 2;
                        if (this.loop()) {
                            this.status = 1;
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                    } else {
                        this.status = 1;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.status = 1;
                }
            }
        }
        catch (Throwable e) {
            Application.getLogger().log(Level.SEVERE, "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc", e);
            return;
        }
    }

    public void gamepadDirectionChanged(int state, int action) {
        if (this.axisKeyProcessor != null) {
            this.axisKeyProcessor.execute(state, action);
            this.currentState = stateTransitionTable[state][action];
            if (this.currentState == 9) {
                this.currentState = state;
            }
        }
    }

    public void gamepadButtonPressed(int number) {
        if (this.buttonKeyProcessor != null) {
            this.buttonKeyProcessor.execute(101, number);
        }
    }

    public void gamepadButtonReleased(int number) {
        if (this.buttonKeyProcessor != null) {
            this.buttonKeyProcessor.execute(100, number);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void execute() {
    }
}

