/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator.device;

import jp.asamomiji.emulator.Addressable;
import jp.asamomiji.emulator.Computer;
import jp.asamomiji.emulator.Device;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.StateSet;

public class R6522
implements Addressable,
Device,
StateSavable {
    protected Computer computer;
    private int startAddr;
    private int endAddr;
    protected byte IFR;
    protected byte IER;
    protected byte PCR;
    protected byte ACR;
    protected byte IRA;
    protected byte ORA;
    protected byte DDRA;
    protected byte IRB;
    protected byte ORB;
    protected byte DDRB;
    protected byte SR;
    public static final int VIA_REG_IORB = 0;
    public static final int VIA_REG_IORA = 1;
    public static final int VIA_REG_DDRB = 2;
    public static final int VIA_REG_DDRA = 3;
    public static final int VIA_REG_T1CL = 4;
    public static final int VIA_REG_T1CH = 5;
    public static final int VIA_REG_T1LL = 6;
    public static final int VIA_REG_T1LH = 7;
    public static final int VIA_REG_T2CL = 8;
    public static final int VIA_REG_T2CH = 9;
    public static final int VIA_REG_SR = 10;
    public static final int VIA_REG_ACR = 11;
    public static final int VIA_REG_PCR = 12;
    public static final int VIA_REG_IFR = 13;
    public static final int VIA_REG_IER = 14;
    public static final int VIA_REG_IORANH = 15;
    protected byte portA;
    protected byte portB;
    protected int CA1in;
    protected int CA2in;
    protected int CA2out;
    protected int CA2timer;
    protected int CB1in;
    protected int CB1out;
    protected int CB2in;
    protected int CB2out;
    protected static final int IFR_BIT_CA2 = 1;
    protected static final int IFR_BIT_CA1 = 2;
    protected static final int IFR_BIT_SR = 4;
    protected static final int IFR_BIT_CB2 = 8;
    protected static final int IFR_BIT_CB1 = 16;
    protected static final int IFR_BIT_T2 = 32;
    protected static final int IFR_BIT_T1 = 64;
    protected static final int IFR_BIT_IRQ = 128;
    private int previousPB6;
    protected short latch1 = 0;
    protected short latch2 = 0;
    protected short timer1 = 0;
    protected short timer2 = 0;
    protected boolean shiftTick = false;
    protected int shiftCounter = 0;
    protected boolean shiftStarted = false;
    protected boolean timer1Initialized = false;
    protected boolean timer1Enable = false;
    protected boolean timer2Initialized = false;
    protected boolean timer2Enable = false;
    protected boolean timer2LowByteTimeout = false;
    protected long currentClock = 0L;

    public R6522(Computer computer, int start) {
        this.computer = computer;
        this.startAddr = start;
        this.endAddr = start + 15;
    }

    @Override
    public int getStartAddress() {
        return this.startAddr;
    }

    @Override
    public int getEndAddress() {
        return this.endAddr;
    }

    private void processIRQ() {
        if ((this.IER & this.IFR & 0x7F) != 0) {
            if ((this.IFR & 0x80) == 0) {
                this.IFR = (byte)(this.IFR | 0x80);
                this.handlerIRQ(1);
            }
        } else if ((this.IFR & 0x80) != 0) {
            this.IFR = (byte)(this.IFR & 0xFFFFFF7F);
            this.handlerIRQ(0);
        }
    }

    private void setInterrupt(int value) {
        if ((this.IFR & value) == 0) {
            this.IFR = (byte)(this.IFR | value);
            this.processIRQ();
        }
    }

    private void clearInterrupt(int value) {
        if ((this.IFR & value) != 0) {
            this.IFR = (byte)(this.IFR & ~value);
            this.processIRQ();
        }
    }

    private boolean isSetInInterrupts(int value) {
        return (this.IFR & value) != 0;
    }

    private boolean isClearedInInterrupts(int value) {
        return (this.IFR & value) == 0;
    }

    public void handlerIRQ(int state) {
    }

    public void setPortA(int bit, int state) {
        int mask = 1 << bit;
        if ((this.DDRA & mask) != 0) {
            return;
        }
        this.portA = state == 1 ? (byte)(this.portA | mask) : (byte)(this.portA & ~mask);
        if ((this.ACR & 1) == 0) {
            this.IRA = this.portA;
        }
    }

    public void setPortA(byte value) {
        this.portA = (byte)(this.portA & this.DDRA | value & ~this.DDRA);
        if ((this.ACR & 1) == 0) {
            this.IRA = this.portA;
        }
    }

    protected byte inputPortA() {
        return (byte)(this.IRA & ~this.DDRA | this.portA & this.DDRA);
    }

    protected int inputPortA(int bit) {
        return (this.inputPortA() & 1 << bit) >> bit;
    }

    protected void outputPortA() {
        this.handlerPortA(this.ORA);
    }

    public void handlerPortA(byte state) {
    }

    public void setCA1(int state) {
        if (this.CA1in != state) {
            this.CA1in = state;
            if (this.CA1in == 1 && (this.PCR & 1) == 1 || this.CA1in == 0 && (this.PCR & 1) == 0) {
                if ((this.ACR & 1) == 1) {
                    this.IRA = this.inputPortA();
                }
                this.setInterrupt(2);
                if (this.CA2out == 0 && (this.PCR & 0xE) == 8) {
                    this.CA2out = 1;
                    this.handlerCA2(this.CA2out);
                }
            }
        }
    }

    public void setCA2(int state) {
        if (this.CA2in != state) {
            this.CA2in = state;
            if ((this.PCR & 8) == 0 && (this.CA2in == 1 && (this.PCR & 0xC) == 4 || this.CA2in == 0 && (this.PCR & 0xC) == 0)) {
                this.setInterrupt(1);
            }
        }
    }

    protected void handlerCA2(int status) {
    }

    public void setPortB(int bit, int state) {
        int mask = 1 << bit;
        if ((this.DDRB & mask) != 0) {
            return;
        }
        this.portB = state == 1 ? (byte)(this.portB | mask) : (byte)(this.portB & ~mask);
        if ((this.ACR & 2) == 0) {
            this.IRB = this.portB;
        }
    }

    public void setPortB(byte value) {
        this.portB = (byte)(this.portB & this.DDRB | value & ~this.DDRB);
        if ((this.ACR & 2) == 0) {
            this.IRB = this.portB;
        }
    }

    protected void invertPortB(int bit) {
        int mask = 1 << bit;
        if ((this.DDRB & mask) != 0) {
            return;
        }
        boolean state = (this.portB & mask) != 0;
        this.portB = !state ? (byte)(this.portB | mask) : (byte)(this.portB & ~mask);
        if ((this.ACR & 2) == 0) {
            this.IRB = this.portB;
        }
    }

    protected byte inputPortB() {
        return (byte)(this.IRB & ~this.DDRB | this.ORB & this.DDRB);
    }

    protected int inputPortB(int bit) {
        return (this.inputPortB() & 1 << bit) >> bit;
    }

    protected void outputPortB() {
        this.handlerPortB(this.ORB);
    }

    public void handlerPortB(int state) {
    }

    public void setCB1(int state) {
        if (this.CB1in != state) {
            this.CB1in = state;
            if (this.CB1in == 1 && (this.PCR & 0x10) == 16 || this.CB1in == 0 && (this.PCR & 0x10) == 0) {
                if ((this.ACR & 2) == 2) {
                    this.IRB = this.inputPortB();
                }
                if (this.shiftStarted && (this.ACR & 0x1C) == 12) {
                    this.processShiftIn();
                }
                if (this.shiftStarted && (this.ACR & 0x1C) == 28) {
                    this.processShiftOut();
                }
                this.setInterrupt(16);
                if (this.CB2out == 0 && (this.PCR & 0xC0) == 128) {
                    this.CB2out = 1;
                    this.handlerCB2(this.CB2out);
                }
            }
        }
    }

    public void setCB2(int state) {
        if (this.CB2in != state) {
            this.CB2in = state;
            if ((this.PCR & 0x80) == 0 && (this.CB2in == 1 && (this.PCR & 0xC0) == 64 || this.CB2in == 0 && (this.PCR & 0xC0) == 0)) {
                this.setInterrupt(8);
            }
        }
    }

    public void handlerCB1(int status) {
    }

    public void handlerCB2(int status) {
    }

    private void initializeShiftIn() {
        this.shiftTick = false;
        this.shiftCounter = 0;
        if (this.isSetInInterrupts(4)) {
            this.clearInterrupt(4);
            this.processShiftIn();
        }
        this.shiftStarted = true;
    }

    private void initializeShiftOut() {
        this.shiftTick = false;
        this.shiftCounter = 0;
        if (this.isSetInInterrupts(4)) {
            this.clearInterrupt(4);
            this.processShiftOut();
        }
        this.shiftStarted = true;
    }

    private void processShiftIn() {
        if (this.shiftTick) {
            this.CB1out = 1;
            this.handlerCB1(this.CB1out);
            this.SR = (byte)((this.SR << 1 | this.CB2in & 1) & 0xFF);
            this.shiftCounter = (this.shiftCounter + 1) % 8;
            if (this.shiftCounter == 0) {
                this.setInterrupt(4);
                this.shiftStarted = false;
            }
        } else {
            this.CB1out = 0;
            this.handlerCB1(this.CB1out);
        }
        this.shiftTick = !this.shiftTick;
    }

    private void processShiftOut() {
        if (this.shiftTick) {
            this.CB1out = 1;
            this.handlerCB1(this.CB1out);
            this.CB2out = (this.SR & 0x80) >> 7;
            this.handlerCB2(this.CB2out);
            this.SR = (byte)((this.SR << 1 | this.CB2out & 1) & 0xFF);
            if ((this.ACR & 0x1C) != 16) {
                this.shiftCounter = (this.shiftCounter + 1) % 8;
                if (this.shiftCounter == 0) {
                    this.setInterrupt(4);
                    this.shiftStarted = false;
                }
            }
        } else {
            this.CB1out = 0;
            this.handlerCB1(this.CB1out);
        }
        this.shiftTick = !this.shiftTick;
    }

    @Override
    public byte load8(int address) {
        int delay = 0;
        byte result = 0;
        this.execute(this.computer.getClockCount() - 1L + (long)delay);
        switch (address - this.startAddr) {
            case 0: {
                result = (this.ACR & 2) == 0 ? (byte)(this.inputPortB() & 0xFF) : (byte)(this.IRB & 0xFF);
                this.clearInterrupt(0x10 | ((this.PCR & 0xA0) == 32 ? 0 : 8));
                break;
            }
            case 1: {
                result = (this.ACR & 1) == 0 ? this.inputPortA() : this.IRA;
                this.clearInterrupt(2 | ((this.PCR & 0xA) == 2 ? 0 : 1));
                if (this.CA2out != 1 || (this.PCR & 0xE) != 10 && (this.PCR & 0xE) != 8) break;
                this.CA2out = 0;
                this.handlerCA2(this.CA2out);
                if ((this.PCR & 0xE) != 8) break;
                this.CA2timer = 1;
                break;
            }
            case 2: {
                result = this.DDRB;
                break;
            }
            case 3: {
                result = this.DDRA;
                break;
            }
            case 4: {
                this.clearInterrupt(64);
                result = (byte)(this.timer1 & 0xFF);
                break;
            }
            case 5: {
                result = (byte)((this.timer1 & 0xFF00) >> 8);
                break;
            }
            case 6: {
                result = (byte)(this.latch1 & 0xFF);
                break;
            }
            case 7: {
                result = (byte)((this.latch1 & 0xFF00) >> 8);
                break;
            }
            case 8: {
                this.clearInterrupt(32);
                result = (byte)(this.timer2 & 0xFF);
                break;
            }
            case 9: {
                result = (byte)((this.timer2 & 0xFF00) >> 8);
                break;
            }
            case 10: {
                switch (this.ACR & 0x1C) {
                    case 0: {
                        break;
                    }
                    case 4: 
                    case 8: 
                    case 12: {
                        this.initializeShiftIn();
                        break;
                    }
                    case 16: 
                    case 20: 
                    case 24: 
                    case 28: {
                        this.initializeShiftOut();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("invalid sr mode " + (this.ACR & 0x1C)));
                    }
                }
                result = this.SR;
                break;
            }
            case 11: {
                result = this.ACR;
                break;
            }
            case 12: {
                result = this.PCR;
                break;
            }
            case 13: {
                result = this.IFR;
                break;
            }
            case 14: {
                result = (byte)(this.IER | 0x80);
                break;
            }
            case 15: {
                result = (this.ACR & 1) == 0 ? this.inputPortA() : this.IRA;
                break;
            }
            default: {
                throw new AssertionError((Object)("invalid register" + address));
            }
        }
        this.execute(this.computer.getClockCount() + (long)delay);
        return result;
    }

    @Override
    public short load16(int address) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void store16(int address, short value) {
        throw new RuntimeException("not supported");
    }

    protected void storeORB_option() {
    }

    protected void storeIORA_option() {
    }

    protected void storeDDRB_option() {
    }

    protected void storeDDRA_option() {
    }

    protected void storeT1CL_option() {
    }

    protected void storeT1CH_option() {
    }

    protected void storeT1LL_option() {
    }

    protected void storeT1LH_option() {
    }

    protected void storeT2CL_option() {
    }

    protected void storeT2CH_option() {
    }

    protected void storeSR_option() {
    }

    protected void storeACR_option() {
    }

    protected void storePCR_option() {
    }

    protected void storeIFR_option() {
    }

    protected void storeIER_option() {
    }

    protected void storeIORA_NOHS_option() {
    }

    @Override
    public void store8(int address, byte value) {
        int delay = 0;
        this.execute(this.computer.getClockCount() - 1L + (long)delay);
        switch (address - this.startAddr) {
            case 0: {
                this.ORB = value;
                this.outputPortB();
                this.clearInterrupt(0x10 | ((this.PCR & 0xA0) == 32 ? 0 : 8));
                if (this.CB2out == 1 && (this.PCR & 0xC0) == 128) {
                    this.CB2out = 0;
                    this.handlerCB2(this.CB2out);
                }
                this.storeORB_option();
                break;
            }
            case 1: {
                this.ORA = value;
                if (this.DDRA != 0) {
                    this.outputPortA();
                }
                this.clearInterrupt(2 | ((this.PCR & 0xA) == 2 ? 0 : 1));
                if (this.CA2out == 1 && ((this.PCR & 0xE) == 10 || (this.PCR & 0xC) == 8)) {
                    this.CA2out = 0;
                    this.handlerCA2(this.CA2out);
                }
                if ((this.PCR & 0xE) == 10) {
                    this.CA2timer = 1;
                }
                this.storeIORA_option();
                break;
            }
            case 2: {
                this.DDRB = value;
                this.storeDDRB_option();
                break;
            }
            case 3: {
                this.DDRA = value;
                this.storeDDRA_option();
                break;
            }
            case 4: {
                this.latch1 = (short)(this.latch1 & 0xFF00);
                this.latch1 = (short)(this.latch1 | value & 0xFF);
                this.storeT1CL_option();
                break;
            }
            case 5: {
                this.latch1 = (short)(this.latch1 & 0xFF);
                this.timer1 = this.latch1 = (short)(this.latch1 | value << 8 & 0xFF00);
                this.timer1Initialized = true;
                this.timer1Enable = true;
                this.setPortB(7, 0);
                this.storeT1CH_option();
                break;
            }
            case 6: {
                this.latch1 = (short)(this.latch1 & 0xFF00);
                this.latch1 = (short)(this.latch1 | value & 0xFF);
                this.storeT1LL_option();
                break;
            }
            case 7: {
                this.latch1 = (short)(this.latch1 & 0xFF);
                this.latch1 = (short)(this.latch1 | value << 8 & 0xFF00);
                this.storeT1LH_option();
                break;
            }
            case 8: {
                this.latch2 = (short)(this.latch2 & 0xFF00);
                this.latch2 = (short)(this.latch2 | value & 0xFF);
                this.storeT2CL_option();
                break;
            }
            case 9: {
                this.latch2 = (short)(this.latch2 & 0xFF);
                this.timer2 = this.latch2 = (short)(this.latch2 | value << 8 & 0xFF00);
                this.clearInterrupt(32);
                this.timer2Initialized = true;
                this.timer2Enable = true;
                this.storeT2CH_option();
                break;
            }
            case 10: {
                switch (this.ACR & 0x1C) {
                    case 4: 
                    case 8: 
                    case 12: {
                        this.initializeShiftIn();
                        break;
                    }
                    case 16: 
                    case 20: 
                    case 24: 
                    case 28: {
                        this.initializeShiftOut();
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("invalid sr mode " + address));
                    }
                }
                this.SR = value;
                this.storeSR_option();
                break;
            }
            case 11: {
                this.ACR = value;
                this.storeACR_option();
                break;
            }
            case 12: {
                this.PCR = value;
                this.storePCR_option();
                break;
            }
            case 13: {
                if ((value & 0x80) == 128) {
                    value = (byte)127;
                }
                this.clearInterrupt(value);
                this.storeIFR_option();
                break;
            }
            case 14: {
                this.IER = value;
                this.storeIER_option();
                break;
            }
            case 15: {
                this.ORA = value;
                if (this.DDRA != 0) {
                    this.outputPortA();
                }
                this.storeIORA_NOHS_option();
                break;
            }
            default: {
                throw new AssertionError((Object)("invalid register" + address));
            }
        }
        this.execute(this.computer.getClockCount() + (long)delay);
    }

    protected void timer1TimeoutMode0_option() {
    }

    protected void timer1TimeoutMode1_option() {
    }

    protected void timer1TimeoutMode2_option() {
    }

    protected void timer1TimeoutMode3_option() {
    }

    private void execute(long clock) {
        while (this.currentClock <= clock) {
            block30: {
                block29: {
                    if (this.CA2timer >= 0) {
                        --this.CA2timer;
                        if (this.CA2timer < 0) {
                            this.CA2out = 1;
                            this.handlerCA2(this.CA2out);
                        }
                    }
                    if (this.timer1Initialized) {
                        this.timer1Initialized = false;
                    } else if (this.timer1 >= 0) {
                        this.timer1 = (short)(this.timer1 - 1);
                    } else {
                        if (this.timer1Enable) {
                            this.setInterrupt(64);
                            switch (this.ACR & 0xC0) {
                                case 0: {
                                    this.timer1Enable = false;
                                    this.timer1TimeoutMode0_option();
                                    break;
                                }
                                case 64: {
                                    this.invertPortB(7);
                                    this.timer1TimeoutMode1_option();
                                    break;
                                }
                                case 128: {
                                    this.timer1Enable = false;
                                    this.setPortB(7, 1);
                                    this.timer1TimeoutMode2_option();
                                    break;
                                }
                                case 192: {
                                    this.invertPortB(7);
                                    this.timer1TimeoutMode3_option();
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("invalid t1mode: " + (this.ACR & 0xC0)));
                                }
                            }
                        }
                        this.timer1 = this.latch1;
                        this.storeT1CH_option();
                    }
                    int currentPB6 = this.inputPortB() & 0x40;
                    boolean PB6negative = this.previousPB6 != 0 && currentPB6 == 0;
                    this.previousPB6 = currentPB6;
                    if (this.timer2 < 0) break block29;
                    switch (this.ACR & 0x20) {
                        case 0: {
                            if (this.timer2Initialized) {
                                this.timer2Initialized = false;
                            } else {
                                this.timer2 = (short)(this.timer2 - 1);
                            }
                            break block30;
                        }
                        case 32: {
                            if (PB6negative) {
                                this.timer2 = (short)(this.timer2 - 1);
                            }
                            break block30;
                        }
                        default: {
                            throw new AssertionError((Object)("invalid t2mode: " + (this.ACR & 0x20)));
                        }
                    }
                }
                if (this.timer2Enable) {
                    this.setInterrupt(32);
                    this.timer2Enable = false;
                }
                if (this.shiftStarted && (this.timer2 & 0xFF) == 255) {
                    if ((this.ACR & 0x1C) == 4) {
                        this.processShiftIn();
                    } else if ((this.ACR & 0x1C) == 16 || (this.ACR & 0x1C) == 20) {
                        this.processShiftOut();
                    }
                }
                this.timer2 = this.latch2;
            }
            if ((this.ACR & 0x1C) == 8) {
                this.processShiftIn();
            } else if ((this.ACR & 0x1C) == 24) {
                this.processShiftOut();
            }
            ++this.currentClock;
        }
    }

    @Override
    public void reset() {
        this.portA = 0;
        this.portB = 0;
        this.CA1in = 0;
        this.CA2in = 0;
        this.CA2out = 0;
        this.CB1in = 0;
        this.CB1out = 0;
        this.CB2in = 0;
        this.CB2out = 0;
        this.CA2timer = -1;
        this.latch1 = 0;
        this.latch2 = 0;
        this.timer1 = 0;
        this.timer2 = 0;
        this.timer1Enable = false;
        this.timer2Enable = false;
        this.timer2LowByteTimeout = false;
        this.previousPB6 = 0;
        this.shiftTick = false;
        this.shiftStarted = false;
        this.shiftCounter = 0;
        this.currentClock = 0L;
    }

    @Override
    public void execute() {
        this.execute(this.computer.getClockCount());
    }

    @Override
    public void saveState(StateSet ss) {
        ss.set("R6522.startAddr", this.startAddr);
        ss.set("R6522.endAddr", this.endAddr);
        ss.set("R6522.IRB", this.IRB);
        ss.set("R6522.ORB", this.ORB);
        ss.set("R6522.IRA", this.IRA);
        ss.set("R6522.ORA", this.ORA);
        ss.set("R6522.DDRB", this.DDRB);
        ss.set("R6522.DDRA", this.DDRA);
        ss.set("R6522.SR", this.SR);
        ss.set("R6522.ACR", this.ACR);
        ss.set("R6522.PCR", this.PCR);
        ss.set("R6522.IFR", this.IFR);
        ss.set("R6522.IER", this.IER);
        ss.set("R6522.portA", this.portA);
        ss.set("R6522.portB", this.portB);
        ss.set("R6522.CA1in", this.CA1in);
        ss.set("R6522.CA2in", this.CA2in);
        ss.set("R6522.CA2out", this.CA2out);
        ss.set("R6522.CA2timer", this.CA2timer);
        ss.set("R6522.CB1in", this.CB1in);
        ss.set("R6522.CB1out", this.CB1out);
        ss.set("R6522.CB2in", this.CB2in);
        ss.set("R6522.CB2out", this.CB2out);
        ss.set("R6522.previousPB6", this.previousPB6);
        ss.set("R6522.latch1", this.latch1);
        ss.set("R6522.latch2", this.latch2);
        ss.set("R6522.timer1", this.timer1);
        ss.set("R6522.timer2", this.timer2);
        ss.set("R6522.shiftTick", this.shiftTick);
        ss.set("R6522.shiftStarted", this.shiftStarted);
        ss.set("R6522.shiftCounter", this.shiftCounter);
        ss.set("R6522.timer1Initialized", this.timer1Initialized);
        ss.set("R6522.timer1Enable", this.timer1Enable);
        ss.set("R6522.timer2Initialized", this.timer2Initialized);
        ss.set("R6522.timer2Enable", this.timer2Enable);
        ss.set("R6522.timer2LowByteTimeout", this.timer2LowByteTimeout);
        ss.set("R6522.currentClock", this.currentClock);
    }

    @Override
    public void loadState(StateSet ss) {
        this.startAddr = (Integer)ss.get("R6522.startAddr");
        this.endAddr = (Integer)ss.get("R6522.endAddr");
        this.IRB = (Byte)ss.get("R6522.IRB");
        this.ORB = (Byte)ss.get("R6522.ORB");
        this.IRA = (Byte)ss.get("R6522.IRA");
        this.ORA = (Byte)ss.get("R6522.ORA");
        this.DDRB = (Byte)ss.get("R6522.DDRB");
        this.DDRA = (Byte)ss.get("R6522.DDRA");
        this.SR = (Byte)ss.get("R6522.SR");
        this.ACR = (Byte)ss.get("R6522.ACR");
        this.PCR = (Byte)ss.get("R6522.PCR");
        this.IFR = (Byte)ss.get("R6522.IFR");
        this.IER = (Byte)ss.get("R6522.IER");
        this.portA = (Byte)ss.get("R6522.portA");
        this.portB = (Byte)ss.get("R6522.portB");
        this.CA1in = (Integer)ss.get("R6522.CA1in");
        this.CA2in = (Integer)ss.get("R6522.CA2in");
        this.CA2out = (Integer)ss.get("R6522.CA2out");
        this.CA2timer = (Integer)ss.get("R6522.CA2timer");
        this.CB1in = (Integer)ss.get("R6522.CB1in");
        this.CB1out = (Integer)ss.get("R6522.CB1out");
        this.CB2in = (Integer)ss.get("R6522.CB2in");
        this.CB2out = (Integer)ss.get("R6522.CB2out");
        this.previousPB6 = (Integer)ss.get("R6522.previousPB6");
        this.latch1 = (Short)ss.get("R6522.latch1");
        this.latch2 = (Short)ss.get("R6522.latch2");
        this.timer1 = (Short)ss.get("R6522.timer1");
        this.timer2 = (Short)ss.get("R6522.timer2");
        this.shiftTick = (Boolean)ss.get("R6522.shiftTick");
        this.shiftStarted = (Boolean)ss.get("R6522.shiftStarted");
        this.shiftCounter = (Integer)ss.get("R6522.shiftCounter");
        this.timer1Initialized = (Boolean)ss.get("R6522.timer1Initialized");
        this.timer1Enable = (Boolean)ss.get("R6522.timer1Enable");
        this.timer2Initialized = (Boolean)ss.get("R6522.timer2Initialized");
        this.timer2Enable = (Boolean)ss.get("R6522.timer2Enable");
        this.timer2LowByteTimeout = (Boolean)ss.get("R6522.timer2LowByteTimeout");
        this.currentClock = (Long)ss.get("R6522.currentClock");
    }
}

