/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import jp.asamomiji.emulator.AbstractHardware;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.CPU;
import jp.asamomiji.emulator.Device;
import jp.asamomiji.emulator.EmulatorEvent;
import jp.asamomiji.emulator.EventQueue;
import jp.asamomiji.emulator.PauseEvent;
import jp.asamomiji.emulator.PowerOffEvent;
import jp.asamomiji.emulator.Program;
import jp.asamomiji.emulator.ResetEvent;
import jp.asamomiji.emulator.ResumeEvent;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.StateSet;
import jp.asamomiji.emulator.TimeManager;
import jp.asamomiji.emulator.device.gamepad.AxisKeyboardKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.ButtonKeyboardKeyProcessor;
import jp.asamomiji.emulator.device.gamepad.ComponentStatus;
import jp.asamomiji.emulator.device.gamepad.Gamepad;
import net.java.games.input.Controller;

public abstract class Computer
implements StateSavable,
Runnable {
    public static final int STATUS_RUNNING = 0;
    public static final int STATUS_PAUSED = 1;
    public static final int STATUS_STOPPED = 2;
    public static final String PROPERTY_AUTOMATIC_POWERON = "system.automatic_power_on";
    public long clockCount = 0L;
    private EventQueue eventQueue = new EventQueue();
    private double refreshRate;
    private CPU cpu;
    private Vector<Device> devices = new Vector();
    private Application application;
    private AbstractHardware hardware;
    private long intervalClocks;
    private int runningStatus;
    private Program program;
    private TimeManager timeManager;
    private long baseTime;

    public Computer(Application application, double refresh_rate) {
        this.application = application;
        this.refreshRate = refresh_rate;
        this.hardware = new AbstractHardware();
        this.clockCount = 0L;
    }

    public static boolean getPropertyOfAutomaticPowerOn() {
        return Boolean.parseBoolean(Application.getProperties().getProperty(PROPERTY_AUTOMATIC_POWERON, "true"));
    }

    public static void setPropertyOfAutomaticPowerOn(boolean value) {
        Application.getProperties().setProperty(PROPERTY_AUTOMATIC_POWERON, Boolean.toString(value));
    }

    public TimeManager getTimeManager() {
        return this.timeManager;
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
    }

    public AbstractHardware getHardware() {
        return this.hardware;
    }

    public void setHardware(AbstractHardware hardware) {
        this.hardware = hardware;
    }

    public Vector<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Vector<Device> devices) {
        this.devices = devices;
    }

    public Application getApplication() {
        return this.application;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public long getClockCount() {
        return this.clockCount;
    }

    public abstract int getClockFrequency();

    public abstract void setClockFrequency(int var1);

    public int getRunningStatus() {
        return this.runningStatus;
    }

    public void setRunningStatus(int status) {
        this.runningStatus = status;
    }

    public void setProgram(Program p) {
        this.program = p;
    }

    public Program getProgram() {
        return this.program;
    }

    @Override
    public void saveState(StateSet ss) {
        ss.set("computer.clockCount", this.clockCount);
        this.cpu.saveState(ss);
        this.hardware.saveState(ss);
    }

    @Override
    public void loadState(StateSet ss) {
        this.clockCount = (Long)ss.get("computer.clockCount");
        this.cpu.loadState(ss);
        this.hardware.loadState(ss);
    }

    public void reset() {
        if (this.getRunningStatus() == 0 || this.getRunningStatus() == 1) {
            this.setRunningStatus(0);
            this.eventQueue.add(new ResetEvent(0L));
        }
    }

    public void pause() {
        if (this.getRunningStatus() == 0) {
            Iterator i = this.eventQueue.iterator();
            while (i.hasNext()) {
                if (!(i.next() instanceof PauseEvent)) continue;
                return;
            }
            this.eventQueue.add(new PauseEvent(0L));
        }
    }

    public void resume() {
        if (this.getRunningStatus() == 1) {
            this.eventQueue.add(new ResumeEvent(0L));
        }
    }

    public void powerOn() {
        this.intervalClocks = (long)(this.refreshRate * (double)this.getClockFrequency());
        this.setRunningStatus(0);
        this.reset();
        this.start();
    }

    public void powerOff() {
        if (this.getRunningStatus() == 0 || this.getRunningStatus() == 1) {
            this.eventQueue.add(new PowerOffEvent(0L));
        }
    }

    private long executeIfPossible(long clocks) {
        if (clocks <= 0L || this.getRunningStatus() != 0) {
            return 0L;
        }
        long a = this.cpu.execute(clocks);
        for (Device d : this.devices) {
            d.execute();
        }
        return a;
    }

    private boolean hasConsumableEvent(long end_clock) {
        if (this.eventQueue.isEmpty()) {
            return false;
        }
        long c = ((EmulatorEvent)this.eventQueue.first()).getClock();
        if (this.getRunningStatus() == 1) {
            return c == 0L;
        }
        return c <= end_clock;
    }

    public void start() {
        double emulator_time = 0.0;
        double real_time = 0.0;
        long clock_adjustment = 0L;
        this.baseTime = System.nanoTime();
        while (this.getRunningStatus() != 2) {
            long end_clock = this.clockCount + this.intervalClocks - clock_adjustment;
            long start = System.nanoTime();
            while (this.hasConsumableEvent(end_clock)) {
                EmulatorEvent event = (EmulatorEvent)this.eventQueue.first();
                this.eventQueue.remove(event);
                this.executeIfPossible(event.getClock() - this.clockCount);
                event.dispatch(this);
            }
            clock_adjustment = this.executeIfPossible(end_clock - this.clockCount);
            this.hardware.getDisplay().refresh();
            long end = System.nanoTime();
            long wait = (long)(this.refreshRate * 1.0E9) - (end - start);
            if ((wait += (long)(emulator_time - real_time)) > 0L) {
                try {
                    Thread.sleep(wait / 1000000L, (int)(wait % 1000000L));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            real_time += (double)(System.nanoTime() - start);
            emulator_time += this.refreshRate * 1.0E9;
        }
    }

    private void gamepadStart() {
        Gamepad g = this.getHardware().getGamepad();
        ComponentStatus[] amap = Gamepad.getPropertyOfGamepadAxisMapping();
        ComponentStatus[] bmap = Gamepad.getPropertyOfGamepadButtonMapping();
        g.setAxisType(Gamepad.getPropertyOfGamepadAxisUsed());
        g.setAxisKeyProcessor(new AxisKeyboardKeyProcessor(g, amap, this.getHardware().getKeyboard()));
        g.setButtonKeyProcessor(new ButtonKeyboardKeyProcessor(g, bmap, this.getHardware().getKeyboard()));
        Controller c = g.searchForController();
        if (c != null) {
            g.setController(c);
        }
        g.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Computer computer;
        block13: {
            try {
                this.timeManager = new TimeManager();
                this.timeManager.start();
                this.gamepadStart();
                if (Computer.getPropertyOfAutomaticPowerOn()) break block13;
                computer = this.application.getComputer();
                synchronized (computer) {
                    try {
                        this.application.getComputer().wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            catch (Throwable e) {
                Application.getLogger().log(Level.SEVERE, "\u5b9f\u884c\u6642\u30a8\u30e9\u30fc", e);
                e.printStackTrace();
                return;
            }
        }
        while (true) {
            this.application.getComputer().powerOn();
            this.application.getComputer().getHardware().getDisplay().repaint();
            computer = this.application.getComputer();
            synchronized (computer) {
                try {
                    this.application.getComputer().wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

