/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.emulator;

import jp.asamomiji.emulator.AbstractDisplay;
import jp.asamomiji.emulator.AbstractKeyboard;
import jp.asamomiji.emulator.AbstractSoundProcessor;
import jp.asamomiji.emulator.Addressable;
import jp.asamomiji.emulator.Application;
import jp.asamomiji.emulator.MemorySystem;
import jp.asamomiji.emulator.StateSavable;
import jp.asamomiji.emulator.StateSet;
import jp.asamomiji.emulator.device.gamepad.Gamepad;

public class AbstractHardware
implements StateSavable {
    private MemorySystem memory = new MemorySystem();
    private AbstractDisplay display = null;
    private AbstractSoundProcessor soundProcessor = null;
    private AbstractKeyboard keyboard = null;
    private Gamepad gamepad = null;
    private Application application = null;

    public MemorySystem getMemory() {
        return this.memory;
    }

    public void setDisplay(AbstractDisplay display) {
        this.display = display;
    }

    public AbstractDisplay getDisplay() {
        return this.display;
    }

    public AbstractSoundProcessor getSoundProcessor() {
        return this.soundProcessor;
    }

    public void setSoundProcessor(AbstractSoundProcessor sound) {
        this.soundProcessor = sound;
    }

    public AbstractKeyboard getKeyboard() {
        return this.keyboard;
    }

    public void setKeyboard(AbstractKeyboard keyboard) {
        this.keyboard = keyboard;
    }

    public Gamepad getGamepad() {
        return this.gamepad;
    }

    public void setGamepad(Gamepad gamepad) {
        this.gamepad = gamepad;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    public void saveState(StateSet ss) {
        for (Addressable m : this.memory.getMemories()) {
            if (!(m instanceof StateSavable)) continue;
            ((StateSavable)((Object)m)).saveState(ss);
        }
        this.display.saveState(ss);
        this.soundProcessor.saveState(ss);
        this.keyboard.saveState(ss);
    }

    @Override
    public void loadState(StateSet ss) {
        for (Addressable m : this.memory.getMemories()) {
            if (!(m instanceof StateSavable)) continue;
            ((StateSavable)((Object)m)).loadState(ss);
        }
        this.display.loadState(ss);
        this.soundProcessor.loadState(ss);
        this.keyboard.loadState(ss);
    }
}

