/*
 * Decompiled with CFR 0.152.
 */
package jp.asamomiji.assembler;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import jp.asamomiji.assembler.ABA;
import jp.asamomiji.assembler.ADCA;
import jp.asamomiji.assembler.ADCB;
import jp.asamomiji.assembler.ADDA;
import jp.asamomiji.assembler.ADDB;
import jp.asamomiji.assembler.ADX;
import jp.asamomiji.assembler.ANDA;
import jp.asamomiji.assembler.ANDB;
import jp.asamomiji.assembler.ASL;
import jp.asamomiji.assembler.ASLA;
import jp.asamomiji.assembler.ASLB;
import jp.asamomiji.assembler.ASR;
import jp.asamomiji.assembler.ASRA;
import jp.asamomiji.assembler.ASRB;
import jp.asamomiji.assembler.BCC;
import jp.asamomiji.assembler.BCS;
import jp.asamomiji.assembler.BEQ;
import jp.asamomiji.assembler.BGE;
import jp.asamomiji.assembler.BGT;
import jp.asamomiji.assembler.BHI;
import jp.asamomiji.assembler.BITA;
import jp.asamomiji.assembler.BITB;
import jp.asamomiji.assembler.BLE;
import jp.asamomiji.assembler.BLS;
import jp.asamomiji.assembler.BLT;
import jp.asamomiji.assembler.BMI;
import jp.asamomiji.assembler.BNE;
import jp.asamomiji.assembler.BPL;
import jp.asamomiji.assembler.BRA;
import jp.asamomiji.assembler.BSR;
import jp.asamomiji.assembler.BVC;
import jp.asamomiji.assembler.BVS;
import jp.asamomiji.assembler.BranchInstruction;
import jp.asamomiji.assembler.CBA;
import jp.asamomiji.assembler.CLC;
import jp.asamomiji.assembler.CLI;
import jp.asamomiji.assembler.CLR;
import jp.asamomiji.assembler.CLRA;
import jp.asamomiji.assembler.CLRB;
import jp.asamomiji.assembler.CLV;
import jp.asamomiji.assembler.CMPA;
import jp.asamomiji.assembler.CMPB;
import jp.asamomiji.assembler.COM;
import jp.asamomiji.assembler.COMA;
import jp.asamomiji.assembler.COMB;
import jp.asamomiji.assembler.CPX;
import jp.asamomiji.assembler.DAA;
import jp.asamomiji.assembler.DEC;
import jp.asamomiji.assembler.DECA;
import jp.asamomiji.assembler.DECB;
import jp.asamomiji.assembler.DES;
import jp.asamomiji.assembler.DEX;
import jp.asamomiji.assembler.EORA;
import jp.asamomiji.assembler.EORB;
import jp.asamomiji.assembler.INC;
import jp.asamomiji.assembler.INCA;
import jp.asamomiji.assembler.INCB;
import jp.asamomiji.assembler.INS;
import jp.asamomiji.assembler.INX;
import jp.asamomiji.assembler.Instruction;
import jp.asamomiji.assembler.JMP;
import jp.asamomiji.assembler.JSR;
import jp.asamomiji.assembler.LDAA;
import jp.asamomiji.assembler.LDAB;
import jp.asamomiji.assembler.LDS;
import jp.asamomiji.assembler.LDX;
import jp.asamomiji.assembler.LSR;
import jp.asamomiji.assembler.LSRA;
import jp.asamomiji.assembler.LSRB;
import jp.asamomiji.assembler.Label;
import jp.asamomiji.assembler.NEG;
import jp.asamomiji.assembler.NEGA;
import jp.asamomiji.assembler.NEGB;
import jp.asamomiji.assembler.NIM;
import jp.asamomiji.assembler.NOP;
import jp.asamomiji.assembler.OIM;
import jp.asamomiji.assembler.ORAA;
import jp.asamomiji.assembler.ORAB;
import jp.asamomiji.assembler.PSHA;
import jp.asamomiji.assembler.PSHB;
import jp.asamomiji.assembler.PULA;
import jp.asamomiji.assembler.PULB;
import jp.asamomiji.assembler.ROL;
import jp.asamomiji.assembler.ROLA;
import jp.asamomiji.assembler.ROLB;
import jp.asamomiji.assembler.ROR;
import jp.asamomiji.assembler.RORA;
import jp.asamomiji.assembler.RORB;
import jp.asamomiji.assembler.RTI;
import jp.asamomiji.assembler.RTS;
import jp.asamomiji.assembler.SBA;
import jp.asamomiji.assembler.SBCA;
import jp.asamomiji.assembler.SBCB;
import jp.asamomiji.assembler.SEC;
import jp.asamomiji.assembler.SEI;
import jp.asamomiji.assembler.SEV;
import jp.asamomiji.assembler.STAA;
import jp.asamomiji.assembler.STAB;
import jp.asamomiji.assembler.STS;
import jp.asamomiji.assembler.STX;
import jp.asamomiji.assembler.SUBA;
import jp.asamomiji.assembler.SUBB;
import jp.asamomiji.assembler.SWI;
import jp.asamomiji.assembler.TAB;
import jp.asamomiji.assembler.TAP;
import jp.asamomiji.assembler.TMM;
import jp.asamomiji.assembler.TPA;
import jp.asamomiji.assembler.TST;
import jp.asamomiji.assembler.TSTA;
import jp.asamomiji.assembler.TSTB;
import jp.asamomiji.assembler.TSX;
import jp.asamomiji.assembler.TXS;
import jp.asamomiji.assembler.UnknownInstruction;
import jp.asamomiji.assembler.WAI;
import jp.asamomiji.assembler.XIM;
import jp.asamomiji.emulator.MemorySystem;

public class Disassembler {
    private Vector<Instruction> instructions = new Vector();
    private byte[] data;
    private int startAddress;
    private int endAddress;

    public Disassembler(byte[] data, int start_address, int end_address) {
        this.data = data;
        this.startAddress = start_address;
        this.endAddress = end_address;
    }

    public Disassembler(MemorySystem m, int start_address, int end_address) {
        this.data = new byte[end_address - start_address + 3];
        this.startAddress = start_address;
        this.endAddress = end_address;
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = m.load8(this.startAddress + i);
            ++i;
        }
    }

    private int getOperand1(int index) {
        if (index >= this.data.length) {
            return 0;
        }
        return this.data[index];
    }

    private int getOperand2(int index) {
        if (index + 1 >= this.data.length) {
            return 0;
        }
        return ((this.data[index] & 0xFF) << 8) + (this.data[index + 1] & 0xFF);
    }

    private void disassemble() {
        int i = 0;
        while (this.startAddress + i < this.endAddress) {
            Instruction inst;
            int a = this.startAddress + i;
            switch (this.data[i] & 0xFF) {
                case 1: {
                    inst = new NOP(a);
                    break;
                }
                case 6: {
                    inst = new TAP(a);
                    break;
                }
                case 7: {
                    inst = new TPA(a);
                    break;
                }
                case 8: {
                    inst = new INX(a);
                    break;
                }
                case 9: {
                    inst = new DEX(a);
                    break;
                }
                case 10: {
                    inst = new CLV(a);
                    break;
                }
                case 11: {
                    inst = new SEV(a);
                    break;
                }
                case 12: {
                    inst = new CLC(a);
                    break;
                }
                case 13: {
                    inst = new SEC(a);
                    break;
                }
                case 14: {
                    inst = new CLI(a);
                    break;
                }
                case 15: {
                    inst = new SEI(a);
                    break;
                }
                case 16: {
                    inst = new SBA(a);
                    break;
                }
                case 17: {
                    inst = new CBA(a);
                    break;
                }
                case 22: {
                    inst = new TAB(a);
                    break;
                }
                case 23: {
                    inst = new TAB(a);
                    break;
                }
                case 25: {
                    inst = new DAA(a);
                    break;
                }
                case 27: {
                    inst = new ABA(a);
                    break;
                }
                case 32: {
                    inst = new BRA(a, this.getOperand1(i + 1));
                    break;
                }
                case 34: {
                    inst = new BHI(a, this.getOperand1(i + 1));
                    break;
                }
                case 35: {
                    inst = new BLS(a, this.getOperand1(i + 1));
                    break;
                }
                case 36: {
                    inst = new BCC(a, this.getOperand1(i + 1));
                    break;
                }
                case 37: {
                    inst = new BCS(a, this.getOperand1(i + 1));
                    break;
                }
                case 38: {
                    inst = new BNE(a, this.getOperand1(i + 1));
                    break;
                }
                case 39: {
                    inst = new BEQ(a, this.getOperand1(i + 1));
                    break;
                }
                case 40: {
                    inst = new BVC(a, this.getOperand1(i + 1));
                    break;
                }
                case 41: {
                    inst = new BVS(a, this.getOperand1(i + 1));
                    break;
                }
                case 42: {
                    inst = new BPL(a, this.getOperand1(i + 1));
                    break;
                }
                case 43: {
                    inst = new BMI(a, this.getOperand1(i + 1));
                    break;
                }
                case 44: {
                    inst = new BGE(a, this.getOperand1(i + 1));
                    break;
                }
                case 45: {
                    inst = new BLT(a, this.getOperand1(i + 1));
                    break;
                }
                case 46: {
                    inst = new BGT(a, this.getOperand1(i + 1));
                    break;
                }
                case 47: {
                    inst = new BLE(a, this.getOperand1(i + 1));
                    break;
                }
                case 48: {
                    inst = new TSX(a);
                    break;
                }
                case 49: {
                    inst = new INS(a);
                    break;
                }
                case 50: {
                    inst = new PULA(a);
                    break;
                }
                case 51: {
                    inst = new PULB(a);
                    break;
                }
                case 52: {
                    inst = new DES(a);
                    break;
                }
                case 53: {
                    inst = new TXS(a);
                    break;
                }
                case 54: {
                    inst = new PSHA(a);
                    break;
                }
                case 55: {
                    inst = new PSHB(a);
                    break;
                }
                case 57: {
                    inst = new RTS(a);
                    break;
                }
                case 59: {
                    inst = new RTI(a);
                    break;
                }
                case 62: {
                    inst = new WAI(a);
                    break;
                }
                case 63: {
                    inst = new SWI(a);
                    break;
                }
                case 64: {
                    inst = new NEGA(a);
                    break;
                }
                case 67: {
                    inst = new COMA(a);
                    break;
                }
                case 68: {
                    inst = new LSRA(a);
                    break;
                }
                case 70: {
                    inst = new RORA(a);
                    break;
                }
                case 71: {
                    inst = new ASRA(a);
                    break;
                }
                case 72: {
                    inst = new ASLA(a);
                    break;
                }
                case 73: {
                    inst = new ROLA(a);
                    break;
                }
                case 74: {
                    inst = new DECA(a);
                    break;
                }
                case 76: {
                    inst = new INCA(a);
                    break;
                }
                case 77: {
                    inst = new TSTA(a);
                    break;
                }
                case 79: {
                    inst = new CLRA(a);
                    break;
                }
                case 80: {
                    inst = new NEGB(a);
                    break;
                }
                case 83: {
                    inst = new COMB(a);
                    break;
                }
                case 84: {
                    inst = new LSRB(a);
                    break;
                }
                case 86: {
                    inst = new RORB(a);
                    break;
                }
                case 87: {
                    inst = new ASRB(a);
                    break;
                }
                case 88: {
                    inst = new ASLB(a);
                    break;
                }
                case 89: {
                    inst = new ROLB(a);
                    break;
                }
                case 90: {
                    inst = new DECB(a);
                    break;
                }
                case 92: {
                    inst = new INCB(a);
                    break;
                }
                case 93: {
                    inst = new TSTB(a);
                    break;
                }
                case 95: {
                    inst = new CLRB(a);
                    break;
                }
                case 96: {
                    inst = new NEG(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 99: {
                    inst = new COM(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 100: {
                    inst = new LSR(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 102: {
                    inst = new ROR(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 103: {
                    inst = new ASR(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 104: {
                    inst = new ASL(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 105: {
                    inst = new ROL(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 106: {
                    inst = new DEC(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 108: {
                    inst = new INC(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 109: {
                    inst = new TST(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 110: {
                    inst = new JMP(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 111: {
                    inst = new CLR(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 112: {
                    inst = new NEG(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 113: {
                    inst = new NIM(a, this.getOperand2(i + 1));
                    break;
                }
                case 114: {
                    inst = new OIM(a, this.getOperand2(i + 1));
                    break;
                }
                case 115: {
                    inst = new COM(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 116: {
                    inst = new LSR(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 117: {
                    inst = new XIM(a, this.getOperand2(i + 1));
                    break;
                }
                case 118: {
                    inst = new ROR(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 119: {
                    inst = new ASR(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 120: {
                    inst = new ASL(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 121: {
                    inst = new ROL(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 122: {
                    inst = new DEC(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 123: {
                    inst = new TMM(a, this.getOperand2(i + 1));
                    break;
                }
                case 124: {
                    inst = new INC(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 125: {
                    inst = new TST(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 126: {
                    inst = new JMP(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 127: {
                    inst = new CLR(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 128: {
                    inst = new SUBA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 129: {
                    inst = new CMPA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 130: {
                    inst = new SBCA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 132: {
                    inst = new ANDA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 133: {
                    inst = new BITA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 134: {
                    inst = new LDAA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 136: {
                    inst = new EORA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 137: {
                    inst = new ADCA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 138: {
                    inst = new ORAA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 139: {
                    inst = new ADDA(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 140: {
                    inst = new CPX(a, 0, this.getOperand2(i + 1));
                    break;
                }
                case 141: {
                    inst = new BSR(a, this.getOperand1(i + 1));
                    break;
                }
                case 142: {
                    inst = new LDS(a, 0, this.getOperand2(i + 1));
                    break;
                }
                case 144: {
                    inst = new SUBA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 145: {
                    inst = new CMPA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 146: {
                    inst = new SBCA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 148: {
                    inst = new ANDA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 149: {
                    inst = new BITA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 150: {
                    inst = new LDAA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 151: {
                    inst = new STAA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 152: {
                    inst = new EORA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 153: {
                    inst = new ADCA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 154: {
                    inst = new ORAA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 155: {
                    inst = new ADDA(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 156: {
                    inst = new CPX(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 158: {
                    inst = new LDS(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 159: {
                    inst = new STS(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 160: {
                    inst = new SUBA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 161: {
                    inst = new CMPA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 162: {
                    inst = new SBCA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 164: {
                    inst = new ANDA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 165: {
                    inst = new BITA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 166: {
                    inst = new LDAA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 167: {
                    inst = new STAA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 168: {
                    inst = new EORA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 169: {
                    inst = new ADCA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 170: {
                    inst = new ORAA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 171: {
                    inst = new ADDA(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 172: {
                    inst = new CPX(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 173: {
                    inst = new JSR(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 174: {
                    inst = new LDS(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 175: {
                    inst = new STS(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 176: {
                    inst = new SUBA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 177: {
                    inst = new CMPA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 178: {
                    inst = new SBCA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 180: {
                    inst = new ANDA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 181: {
                    inst = new BITA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 182: {
                    inst = new LDAA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 183: {
                    inst = new STAA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 184: {
                    inst = new EORA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 185: {
                    inst = new ADCA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 186: {
                    inst = new ORAA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 187: {
                    inst = new ADDA(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 188: {
                    inst = new CPX(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 189: {
                    inst = new JSR(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 190: {
                    inst = new LDS(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 191: {
                    inst = new STS(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 192: {
                    inst = new SUBB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 193: {
                    inst = new CMPB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 194: {
                    inst = new SBCB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 196: {
                    inst = new ANDB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 197: {
                    inst = new BITB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 198: {
                    inst = new LDAB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 200: {
                    inst = new EORB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 201: {
                    inst = new ADCB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 202: {
                    inst = new ORAB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 203: {
                    inst = new ADDB(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 206: {
                    inst = new LDX(a, 0, this.getOperand2(i + 1));
                    break;
                }
                case 208: {
                    inst = new SUBB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 209: {
                    inst = new CMPB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 210: {
                    inst = new SBCB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 212: {
                    inst = new ANDB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 213: {
                    inst = new BITB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 214: {
                    inst = new LDAB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 215: {
                    inst = new STAB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 216: {
                    inst = new EORB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 217: {
                    inst = new ADCB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 218: {
                    inst = new ORAB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 219: {
                    inst = new ADDB(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 222: {
                    inst = new LDX(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 223: {
                    inst = new STX(a, 1, this.getOperand1(i + 1));
                    break;
                }
                case 224: {
                    inst = new SUBB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 225: {
                    inst = new CMPB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 226: {
                    inst = new SBCB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 228: {
                    inst = new ANDB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 229: {
                    inst = new BITB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 230: {
                    inst = new LDAB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 231: {
                    inst = new STAB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 232: {
                    inst = new EORB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 233: {
                    inst = new ADCB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 234: {
                    inst = new ORAB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 235: {
                    inst = new ADDB(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 236: {
                    inst = new ADX(a, 0, this.getOperand1(i + 1));
                    break;
                }
                case 238: {
                    inst = new LDX(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 239: {
                    inst = new STX(a, 2, this.getOperand1(i + 1));
                    break;
                }
                case 240: {
                    inst = new SUBB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 241: {
                    inst = new CMPB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 242: {
                    inst = new SBCB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 244: {
                    inst = new ANDB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 245: {
                    inst = new BITB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 246: {
                    inst = new LDAB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 247: {
                    inst = new STAB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 248: {
                    inst = new EORB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 249: {
                    inst = new ADCB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 250: {
                    inst = new ORAB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 251: {
                    inst = new ADDB(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 252: {
                    inst = new ADX(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 254: {
                    inst = new LDX(a, 3, this.getOperand2(i + 1));
                    break;
                }
                case 255: {
                    inst = new STX(a, 3, this.getOperand2(i + 1));
                    break;
                }
                default: {
                    inst = new UnknownInstruction(a);
                }
            }
            this.instructions.add(inst);
            i += inst.getLength();
        }
    }

    private void resolveBranch() {
        int label_number = 1;
        for (Instruction i : this.instructions) {
            if (!i.isBranch()) continue;
            BranchInstruction b = (BranchInstruction)i;
            int target_address = b.getTargetAddress();
            for (Instruction j : this.instructions) {
                if (j.getAddress() != target_address) continue;
                if (!j.isBranchTarget()) {
                    j.setBranchTarget();
                    j.setLabel(new Label(label_number++));
                }
                b.setTarget(j);
            }
        }
    }

    private void sortLabel() {
        Vector<Instruction> labels = new Vector<Instruction>();
        for (Instruction i : this.instructions) {
            if (i.getLabel() == null) continue;
            labels.add(i);
        }
        Collections.sort(labels, new Comparator<Instruction>(){

            @Override
            public int compare(Instruction i1, Instruction i2) {
                if (i1.getAddress() < i2.getAddress()) {
                    return -1;
                }
                if (i1.getAddress() > i2.getAddress()) {
                    return 1;
                }
                return 0;
            }
        });
        int labelNumber = 1;
        for (Instruction i : labels) {
            i.getLabel().setNumber(labelNumber++);
        }
    }

    public String print() {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        for (Instruction i : this.instructions) {
            if (i.getLabel() != null) {
                sb.append(String.valueOf(i.getLabel().toString()) + ":\n");
            }
            sb.append(String.format("    %04x ", i.getAddress()));
            int n = 0;
            while (n < 3) {
                if (n < i.getLength()) {
                    sb.append(String.format("%02x ", this.data[index++]));
                } else {
                    sb.append("   ");
                }
                ++n;
            }
            sb.append(String.format("   %-5s %s\n", i.getMnemonic(), i.getOperandString()));
        }
        return sb.toString();
    }

    public void execute() {
        this.disassemble();
        this.resolveBranch();
        this.sortLabel();
    }
}

